/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.http;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.NullNode;
import com.github.tomakehurst.wiremock.common.ContentTypes;
import com.github.tomakehurst.wiremock.common.Encoding;
import com.github.tomakehurst.wiremock.common.Json;
import com.github.tomakehurst.wiremock.common.Strings;
import com.github.tomakehurst.wiremock.http.ContentTypeHeader;
import java.util.Arrays;
import java.util.Objects;

public class Body {
    private final byte[] content;
    private final boolean binary;
    private final boolean json;
    private static final Body EMPTY_BODY = new Body((byte[])null);

    public Body(byte[] content) {
        this(content, true);
    }

    public Body(String content) {
        this.content = Strings.bytesFromString(content);
        this.binary = false;
        this.json = false;
    }

    private Body(byte[] content, boolean binary) {
        this.content = content;
        this.binary = binary;
        this.json = false;
    }

    private Body(byte[] content, boolean binary, boolean json) {
        this.content = content;
        this.binary = binary;
        this.json = json;
    }

    private Body(JsonNode content) {
        this.content = Json.toByteArray(content);
        this.binary = false;
        this.json = true;
    }

    static Body fromBytes(byte[] bytes) {
        return bytes != null ? new Body(bytes) : Body.none();
    }

    public static Body fromJsonBytes(byte[] bytes) {
        return bytes != null ? new Body(bytes, false, true) : Body.none();
    }

    static Body fromString(String str) {
        return str != null ? new Body(str) : Body.none();
    }

    public static Body ofBinaryOrText(byte[] content, ContentTypeHeader contentTypeHeader) {
        return new Body(content, ContentTypes.determineIsTextFromMimeType(contentTypeHeader.mimeTypePart()));
    }

    public static Body fromOneOf(byte[] bytes, String str, JsonNode json, String base64) {
        if (bytes != null) {
            return new Body(bytes);
        }
        if (str != null) {
            return new Body(str);
        }
        if (json != null && !(json instanceof NullNode)) {
            return new Body(json);
        }
        if (base64 != null) {
            return new Body(Encoding.decodeBase64(base64), true);
        }
        return Body.none();
    }

    public static Body none() {
        return EMPTY_BODY;
    }

    public String asString() {
        return this.content != null ? Strings.stringFromBytes(this.content) : null;
    }

    public byte[] asBytes() {
        return this.content != null ? this.content : null;
    }

    public String asBase64() {
        return Encoding.encodeBase64(this.content);
    }

    public boolean isBinary() {
        return this.binary;
    }

    public JsonNode asJson() {
        return Json.node(this.asString());
    }

    public boolean isJson() {
        return this.json;
    }

    public boolean isAbsent() {
        return this.content == null;
    }

    public boolean isPresent() {
        return !this.isAbsent();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Body body = (Body)o;
        return Objects.equals(this.binary, body.binary) && Arrays.equals(this.content, body.content);
    }

    public int hashCode() {
        return Objects.hash(this.content, this.binary);
    }

    public String toString() {
        return "Body {content=" + this.asString() + ", binary=" + this.binary + ", json=" + this.json + "}";
    }
}

