/*
 * Decompiled with CFR 0.152.
 */
package wiremock.org.mortbay.jetty.servlet;

import java.security.SecureRandom;
import java.util.Random;
import javax.servlet.http.HttpServletRequest;
import wiremock.org.mortbay.component.AbstractLifeCycle;
import wiremock.org.mortbay.jetty.Server;
import wiremock.org.mortbay.jetty.SessionIdManager;
import wiremock.org.mortbay.log.Log;

public abstract class AbstractSessionIdManager
extends AbstractLifeCycle
implements SessionIdManager {
    private static final String __NEW_SESSION_ID = "wiremock.org.mortbay.jetty.newSessionId";
    protected Random _random;
    protected boolean _weakRandom;
    protected String _workerName;
    protected Server _server;

    public AbstractSessionIdManager(Server server) {
        this._server = server;
    }

    public AbstractSessionIdManager(Server server, Random random) {
        this._random = random;
        this._server = server;
    }

    public String getWorkerName() {
        return this._workerName;
    }

    public void setWorkerName(String name) {
        this._workerName = name;
    }

    public Random getRandom() {
        return this._random;
    }

    public void setRandom(Random random) {
        this._random = random;
        this._weakRandom = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String newSessionId(HttpServletRequest request, long created) {
        AbstractSessionIdManager abstractSessionIdManager = this;
        synchronized (abstractSessionIdManager) {
            String cluster_id;
            String requested_id = request.getRequestedSessionId();
            if (requested_id != null && this.idInUse(cluster_id = this.getClusterId(requested_id))) {
                return cluster_id;
            }
            String new_id = (String)request.getAttribute(__NEW_SESSION_ID);
            if (new_id != null && this.idInUse(new_id)) {
                return new_id;
            }
            String id = null;
            while (id == null || id.length() == 0 || this.idInUse(id)) {
                long r1;
                long r0;
                long l = r0 = this._weakRandom ? (long)this.hashCode() ^ Runtime.getRuntime().freeMemory() ^ (long)this._random.nextInt() ^ (long)request.hashCode() << 32 : this._random.nextLong();
                if (r0 < 0L) {
                    r0 = -r0;
                }
                long l2 = r1 = this._weakRandom ? (long)this.hashCode() ^ Runtime.getRuntime().freeMemory() ^ (long)this._random.nextInt() ^ (long)request.hashCode() << 32 : this._random.nextLong();
                if (r1 < 0L) {
                    r1 = -r1;
                }
                id = Long.toString(r0, 36) + Long.toString(r1, 36);
                if (this._workerName == null) continue;
                id = this._workerName + id;
            }
            request.setAttribute(__NEW_SESSION_ID, id);
            return id;
        }
    }

    public void doStart() {
        this.initRandom();
    }

    public void initRandom() {
        if (this._random == null) {
            try {
                this._random = new SecureRandom();
                this._weakRandom = false;
            }
            catch (Exception e) {
                Log.warn("Could not generate SecureRandom for session-id randomness", e);
                this._random = new Random();
                this._weakRandom = true;
            }
        }
        this._random.setSeed(this._random.nextLong() ^ System.currentTimeMillis() ^ (long)this.hashCode() ^ Runtime.getRuntime().freeMemory());
    }
}

