/*
 * Decompiled with CFR 0.152.
 */
package wiremock.org.apache.http.message;

import java.io.Serializable;
import wiremock.org.apache.http.ProtocolVersion;
import wiremock.org.apache.http.StatusLine;
import wiremock.org.apache.http.annotation.Immutable;
import wiremock.org.apache.http.message.BasicLineFormatter;
import wiremock.org.apache.http.util.Args;

@Immutable
public class BasicStatusLine
implements StatusLine,
Cloneable,
Serializable {
    private static final long serialVersionUID = -2443303766890459269L;
    private final ProtocolVersion protoVersion;
    private final int statusCode;
    private final String reasonPhrase;

    public BasicStatusLine(ProtocolVersion version, int statusCode, String reasonPhrase) {
        this.protoVersion = Args.notNull(version, "Version");
        this.statusCode = Args.notNegative(statusCode, "Status code");
        this.reasonPhrase = reasonPhrase;
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public ProtocolVersion getProtocolVersion() {
        return this.protoVersion;
    }

    public String getReasonPhrase() {
        return this.reasonPhrase;
    }

    public String toString() {
        return BasicLineFormatter.INSTANCE.formatStatusLine(null, this).toString();
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }
}

