/*
 * Decompiled with CFR 0.152.
 */
package wiremock.com.jayway.jsonpath;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import wiremock.com.jayway.jsonpath.InvalidCriteriaException;
import wiremock.org.apache.commons.lang.Validate;

public class Criteria {
    private static final Object NOT_SET = new Object();
    private final String key;
    private final List<Criteria> criteriaChain;
    private final LinkedHashMap<CriteriaType, Object> criteria = new LinkedHashMap();
    private Object isValue = NOT_SET;

    private Criteria(String key) {
        Validate.notEmpty(key, "key can not be null or empty");
        this.criteriaChain = new ArrayList<Criteria>();
        this.criteriaChain.add(this);
        this.key = key;
    }

    private Criteria(List<Criteria> criteriaChain, String key) {
        Validate.notEmpty(key, "key can not be null or empty");
        this.criteriaChain = criteriaChain;
        this.criteriaChain.add(this);
        this.key = key;
    }

    public String getKey() {
        return this.key;
    }

    public boolean matches(Map<String, Object> map) {
        if (this.criteriaChain.size() == 1) {
            return this.criteriaChain.get(0).singleObjectApply(map);
        }
        for (Criteria c : this.criteriaChain) {
            if (c.singleObjectApply(map)) continue;
            return false;
        }
        return true;
    }

    boolean singleObjectApply(Map<String, Object> map) {
        Iterator<CriteriaType> i$ = this.criteria.keySet().iterator();
        if (i$.hasNext()) {
            CriteriaType key = i$.next();
            Object actualVal = map.get(this.key);
            Object expectedVal = this.criteria.get((Object)key);
            if (CriteriaType.GT.equals((Object)key)) {
                if (expectedVal == null || actualVal == null) {
                    return false;
                }
                Number expectedNumber = (Number)expectedVal;
                Number actualNumber = (Number)actualVal;
                return actualNumber.doubleValue() > expectedNumber.doubleValue();
            }
            if (CriteriaType.GTE.equals((Object)key)) {
                if (expectedVal == null || actualVal == null) {
                    return false;
                }
                Number expectedNumber = (Number)expectedVal;
                Number actualNumber = (Number)actualVal;
                return actualNumber.doubleValue() >= expectedNumber.doubleValue();
            }
            if (CriteriaType.LT.equals((Object)key)) {
                if (expectedVal == null || actualVal == null) {
                    return false;
                }
                Number expectedNumber = (Number)expectedVal;
                Number actualNumber = (Number)actualVal;
                return actualNumber.doubleValue() < expectedNumber.doubleValue();
            }
            if (CriteriaType.LTE.equals((Object)key)) {
                if (expectedVal == null || actualVal == null) {
                    return false;
                }
                Number expectedNumber = (Number)expectedVal;
                Number actualNumber = (Number)actualVal;
                return actualNumber.doubleValue() <= expectedNumber.doubleValue();
            }
            if (CriteriaType.NE.equals((Object)key)) {
                if (expectedVal == null && actualVal == null) {
                    return false;
                }
                if (expectedVal == null) {
                    return true;
                }
                return !expectedVal.equals(actualVal);
            }
            if (CriteriaType.IN.equals((Object)key)) {
                Collection exp = (Collection)expectedVal;
                return exp.contains(actualVal);
            }
            if (CriteriaType.NIN.equals((Object)key)) {
                Collection exp = (Collection)expectedVal;
                return !exp.contains(actualVal);
            }
            if (CriteriaType.ALL.equals((Object)key)) {
                Collection exp = (Collection)expectedVal;
                Collection act = (Collection)actualVal;
                return act.containsAll(exp);
            }
            if (CriteriaType.SIZE.equals((Object)key)) {
                int exp = (Integer)expectedVal;
                List act = (List)actualVal;
                return act.size() == exp;
            }
            if (CriteriaType.EXISTS.equals((Object)key)) {
                boolean exp = (Boolean)expectedVal;
                boolean act = map.containsKey(this.key);
                return act == exp;
            }
            if (CriteriaType.TYPE.equals((Object)key)) {
                Object actVal;
                Class exp = (Class)expectedVal;
                Class<?> act = null;
                if (map.containsKey(this.key) && (actVal = map.get(this.key)) != null) {
                    act = actVal.getClass();
                }
                if (act == null) {
                    return false;
                }
                return act.equals(exp);
            }
            if (CriteriaType.REGEX.equals((Object)key)) {
                Pattern exp = (Pattern)expectedVal;
                String act = (String)actualVal;
                if (act == null) {
                    return false;
                }
                return exp.matcher(act).matches();
            }
            throw new UnsupportedOperationException("Criteria type not supported: " + key.name());
        }
        if (this.isValue != NOT_SET) {
            if (this.isValue instanceof Collection) {
                Collection cs = (Collection)this.isValue;
                for (Criteria crit : cs) {
                    for (Criteria c : crit.criteriaChain) {
                        if (c.singleObjectApply(map)) continue;
                        return false;
                    }
                }
                return true;
            }
            if (this.isValue == null) {
                return map.get(this.key) == null;
            }
            return this.isValue.equals(map.get(this.key));
        }
        return true;
    }

    public static Criteria where(String key) {
        return new Criteria(key);
    }

    public Criteria and(String key) {
        return new Criteria(this.criteriaChain, key);
    }

    public Criteria is(Object o) {
        if (this.isValue != NOT_SET) {
            throw new InvalidCriteriaException("Multiple 'is' values declared. You need to use 'and' with multiple criteria");
        }
        if (this.criteria.size() > 0 && "$not".equals(this.criteria.keySet().toArray()[this.criteria.size() - 1])) {
            throw new InvalidCriteriaException("Invalid query: 'not' can't be used with 'is' - use 'ne' instead.");
        }
        this.isValue = o;
        return this;
    }

    public Criteria eq(Object o) {
        return this.is(o);
    }

    public Criteria ne(Object o) {
        this.criteria.put(CriteriaType.NE, o);
        return this;
    }

    public Criteria lt(Object o) {
        this.criteria.put(CriteriaType.LT, o);
        return this;
    }

    public Criteria lte(Object o) {
        this.criteria.put(CriteriaType.LTE, o);
        return this;
    }

    public Criteria gt(Object o) {
        this.criteria.put(CriteriaType.GT, o);
        return this;
    }

    public Criteria gte(Object o) {
        this.criteria.put(CriteriaType.GTE, o);
        return this;
    }

    public Criteria in(Object ... o) {
        if (o.length > 1 && o[1] instanceof Collection) {
            throw new InvalidCriteriaException("You can only pass in one argument of type " + o[1].getClass().getName());
        }
        return this.in(Arrays.asList(o));
    }

    public Criteria in(Collection<?> c) {
        Validate.notNull(c, "collection can not be null");
        this.criteria.put(CriteriaType.IN, c);
        return this;
    }

    public Criteria nin(Object ... o) {
        return this.nin(Arrays.asList(o));
    }

    public Criteria nin(Collection<?> c) {
        Validate.notNull(c, "collection can not be null");
        this.criteria.put(CriteriaType.NIN, c);
        return this;
    }

    public Criteria all(Object ... o) {
        return this.all(Arrays.asList(o));
    }

    public Criteria all(Collection<?> c) {
        Validate.notNull(c, "collection can not be null");
        this.criteria.put(CriteriaType.ALL, c);
        return this;
    }

    public Criteria size(int s) {
        this.criteria.put(CriteriaType.SIZE, s);
        return this;
    }

    public Criteria exists(boolean b) {
        this.criteria.put(CriteriaType.EXISTS, b);
        return this;
    }

    public Criteria type(Class<?> t) {
        Validate.notNull(t, "type can not be null");
        this.criteria.put(CriteriaType.TYPE, t);
        return this;
    }

    public Criteria regex(Pattern pattern) {
        Validate.notNull(pattern, "pattern can not be null");
        this.criteria.put(CriteriaType.REGEX, pattern);
        return this;
    }

    public Criteria andOperator(Criteria ... criteria) {
        this.criteriaChain.add(new Criteria("$and").is(Arrays.asList(criteria)));
        return this;
    }

    private static enum CriteriaType {
        GT,
        GTE,
        LT,
        LTE,
        NE,
        IN,
        NIN,
        ALL,
        SIZE,
        EXISTS,
        TYPE,
        REGEX,
        OR;

    }
}

