/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.standalone;

import com.github.tomakehurst.wiremock.Log4jConfiguration;
import com.github.tomakehurst.wiremock.WireMockServer;
import com.github.tomakehurst.wiremock.common.FatalStartupException;
import com.github.tomakehurst.wiremock.common.FileSource;
import com.github.tomakehurst.wiremock.http.RequestMethod;
import com.github.tomakehurst.wiremock.http.ResponseDefinition;
import com.github.tomakehurst.wiremock.matching.RequestPattern;
import com.github.tomakehurst.wiremock.standalone.CommandLineOptions;
import com.github.tomakehurst.wiremock.standalone.MappingsLoader;
import com.github.tomakehurst.wiremock.stubbing.StubMapping;
import com.github.tomakehurst.wiremock.stubbing.StubMappings;

public class WireMockServerRunner {
    private WireMockServer wireMockServer;

    public void run(String ... args) {
        CommandLineOptions options = new CommandLineOptions(args);
        if (options.help()) {
            System.out.println(options.helpText());
            return;
        }
        Log4jConfiguration.configureLogging(options.verboseLoggingEnabled());
        FileSource fileSource = options.filesRoot();
        fileSource.createIfNecessary();
        FileSource filesFileSource = fileSource.child("__files");
        filesFileSource.createIfNecessary();
        FileSource mappingsFileSource = fileSource.child("mappings");
        mappingsFileSource.createIfNecessary();
        this.wireMockServer = new WireMockServer(options);
        if (options.recordMappingsEnabled()) {
            this.wireMockServer.enableRecordMappings(mappingsFileSource, filesFileSource);
        }
        if (options.specifiesProxyUrl()) {
            this.addProxyMapping(options.proxyUrl());
        }
        try {
            this.wireMockServer.start();
        }
        catch (FatalStartupException e) {
            System.err.println(e.getMessage());
            System.exit(1);
        }
    }

    private void addProxyMapping(final String baseUrl) {
        this.wireMockServer.loadMappingsUsing(new MappingsLoader(){

            @Override
            public void loadMappingsInto(StubMappings stubMappings) {
                RequestPattern requestPattern = new RequestPattern(RequestMethod.ANY);
                requestPattern.setUrlPattern(".*");
                ResponseDefinition responseDef = new ResponseDefinition();
                responseDef.setProxyBaseUrl(baseUrl);
                StubMapping proxyBasedMapping = new StubMapping(requestPattern, responseDef);
                proxyBasedMapping.setPriority(10);
                stubMappings.addMapping(proxyBasedMapping);
            }
        });
    }

    public void stop() {
        this.wireMockServer.stop();
    }

    public boolean isRunning() {
        return this.wireMockServer.isRunning();
    }

    public static void main(String ... args) {
        new WireMockServerRunner().run(args);
    }
}

