/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.servlet;

import com.github.tomakehurst.wiremock.http.ContentTypeHeader;
import com.github.tomakehurst.wiremock.http.HttpHeader;
import com.github.tomakehurst.wiremock.http.HttpHeaders;
import com.github.tomakehurst.wiremock.http.Request;
import com.github.tomakehurst.wiremock.http.RequestMethod;
import com.github.tomakehurst.wiremock.jetty.ServletContainerUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import wiremock.com.google.common.base.Charsets;
import wiremock.com.google.common.base.Strings;
import wiremock.com.google.common.collect.Lists;
import wiremock.com.google.common.io.ByteStreams;

public class HttpServletRequestAdapter
implements Request {
    private final HttpServletRequest request;
    private String cachedBody;
    private String urlPrefixToRemove;

    public HttpServletRequestAdapter(HttpServletRequest request) {
        this.request = request;
    }

    public HttpServletRequestAdapter(HttpServletRequest request, String urlPrefixToRemove) {
        this.request = request;
        this.urlPrefixToRemove = urlPrefixToRemove;
    }

    @Override
    public String getUrl() {
        String url = this.request.getRequestURI();
        String contextPath = this.request.getContextPath();
        if (!Strings.isNullOrEmpty(contextPath) && url.startsWith(contextPath)) {
            url = url.substring(contextPath.length());
        }
        if (!Strings.isNullOrEmpty(this.urlPrefixToRemove) && url.startsWith(this.urlPrefixToRemove)) {
            url = url.substring(this.urlPrefixToRemove.length());
        }
        return this.withQueryStringIfPresent(url);
    }

    @Override
    public String getAbsoluteUrl() {
        return this.withQueryStringIfPresent(this.request.getRequestURL().toString());
    }

    private String withQueryStringIfPresent(String url) {
        return url + (Strings.isNullOrEmpty(this.request.getQueryString()) ? "" : "?" + this.request.getQueryString());
    }

    @Override
    public RequestMethod getMethod() {
        return RequestMethod.valueOf(this.request.getMethod().toUpperCase());
    }

    @Override
    public String getBodyAsString() {
        if (this.cachedBody == null) {
            try {
                this.cachedBody = new String(ByteStreams.toByteArray(this.request.getInputStream()), Charsets.UTF_8);
            }
            catch (IOException ioe) {
                throw new RuntimeException(ioe);
            }
        }
        return this.cachedBody;
    }

    @Override
    public String getHeader(String key) {
        ArrayList<String> headerNames = Collections.list(this.request.getHeaderNames());
        for (String currentKey : headerNames) {
            if (!currentKey.toLowerCase().equals(key.toLowerCase())) continue;
            return this.request.getHeader(currentKey);
        }
        return null;
    }

    @Override
    public HttpHeader header(String key) {
        ArrayList<String> headerNames = Collections.list(this.request.getHeaderNames());
        for (String currentKey : headerNames) {
            if (!currentKey.toLowerCase().equals(key.toLowerCase())) continue;
            ArrayList<String> valueList = Collections.list(this.request.getHeaders(currentKey));
            return new HttpHeader(key, valueList);
        }
        return HttpHeader.absent(key);
    }

    @Override
    public ContentTypeHeader contentTypeHeader() {
        return this.getHeaders().getContentTypeHeader();
    }

    @Override
    public boolean containsHeader(String key) {
        return this.header(key).isPresent();
    }

    @Override
    public HttpHeaders getHeaders() {
        ArrayList<HttpHeader> headerList = Lists.newArrayList();
        for (String key : this.getAllHeaderKeys()) {
            headerList.add(this.header(key));
        }
        return new HttpHeaders(headerList);
    }

    @Override
    public Set<String> getAllHeaderKeys() {
        LinkedHashSet<String> headerKeys = new LinkedHashSet<String>();
        Enumeration headerNames = this.request.getHeaderNames();
        while (headerNames.hasMoreElements()) {
            headerKeys.add((String)headerNames.nextElement());
        }
        return headerKeys;
    }

    @Override
    public boolean isBrowserProxyRequest() {
        return ServletContainerUtils.isBrowserProxyRequest(this.request);
    }

    public String toString() {
        return this.request.toString() + this.getBodyAsString();
    }
}

