/*
 * Decompiled with CFR 0.152.
 */
package com.github.tjake.jlama.model.qwen2;

import com.github.tjake.jlama.model.AbstractModel;
import com.github.tjake.jlama.model.CausalSelfAttention;
import com.github.tjake.jlama.model.MLPBlock;
import com.github.tjake.jlama.model.ModelSupport;
import com.github.tjake.jlama.model.RMSNorm;
import com.github.tjake.jlama.model.TransformerBlock;
import com.github.tjake.jlama.model.llama.LlamaModel;
import com.github.tjake.jlama.safetensors.Config;
import com.github.tjake.jlama.safetensors.DType;
import com.github.tjake.jlama.safetensors.WeightLoader;
import com.github.tjake.jlama.safetensors.tokenizer.Tokenizer;
import java.util.Optional;
import java.util.stream.IntStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Qwen2Model
extends LlamaModel {
    private static final Logger logger = LoggerFactory.getLogger(Qwen2Model.class);

    public Qwen2Model(Config config, WeightLoader weights, Tokenizer tokenizer, DType workingDType, DType workingQType, Optional<DType> modelQType) {
        super(config, weights, tokenizer, workingDType, workingQType, modelQType);
    }

    public Qwen2Model(AbstractModel.InferenceType inferenceType, Config config, WeightLoader weights, Tokenizer tokenizer, DType workingDType, DType workingQType, Optional<DType> modelQType) {
        super(inferenceType, config, weights, tokenizer, workingDType, workingQType, modelQType);
    }

    @Override
    protected TransformerBlock[] loadTransformerBlockWeights() {
        DType qType = this.modelQType.orElse(this.modelDType);
        if (qType != this.modelDType) {
            logger.info("Quantizing model with {} - Please hold...", (Object)qType);
        }
        TransformerBlock[] transformerBlocks = new TransformerBlock[this.c.dctx().numberOfLayers];
        IntStream.range(this.c.dctx().layerStart, this.c.dctx().layerEnd).parallel().forEach(i -> {
            int relativeLayer = i - this.c.dctx().layerStart;
            String base = "model.layers." + i + ".";
            String prefix = base + "self_attn.";
            CausalSelfAttention attention = new CausalSelfAttention((AbstractModel)this, relativeLayer, Optional.of(this.weights.load(prefix + "q_proj.bias").quantize(qType)), Optional.of(this.weights.load(prefix + "k_proj.bias").quantize(qType)), Optional.of(this.weights.load(prefix + "v_proj.bias").quantize(qType)), this.weights.load(prefix + "q_proj.weight", this.c.dctx(), true, false).quantize(qType), this.weights.load(prefix + "k_proj.weight", this.c.dctx(), true, false).quantize(qType), this.weights.load(prefix + "v_proj.weight", this.c.dctx(), true, false).quantize(qType), Optional.empty(), this.weights.load(prefix + "o_proj.weight", this.c.dctx(), false, true).quantize(qType));
            prefix = base + "mlp.";
            MLPBlock mlp = new MLPBlock(this, this.c.activationFunction, this.weights.load(prefix + "gate_proj.weight", this.c.dctx(), true, false).quantize(qType), this.weights.load(prefix + "down_proj.weight", this.c.dctx(), false, true).quantize(qType), this.weights.load(prefix + "up_proj.weight", this.c.dctx(), true, false).quantize(qType));
            transformerBlocks[relativeLayer] = new TransformerBlock((AbstractModel)this, relativeLayer, new RMSNorm(this, this.weights.load(base + "input_layernorm.weight").quantize(qType)), attention, new RMSNorm(this, this.weights.load(base + "post_attention_layernorm.weight").quantize(qType)), mlp);
        });
        return transformerBlocks;
    }

    @Override
    public ModelSupport.ModelType getModelType() {
        return ModelSupport.ModelType.QWEN2;
    }
}

