/*
 * Decompiled with CFR 0.152.
 */
package com.github.terma.javaniotcpserver;

import com.github.terma.javaniotcpserver.TcpServerHandlerFactory;

public class TcpServerConfig {
    private final int port;
    private final int workerCount;
    private final TcpServerHandlerFactory handlerFactory;

    public TcpServerConfig(int port, TcpServerHandlerFactory handlerFactory, int workerCount) {
        if (workerCount < 1) {
            throw new IllegalArgumentException("Count of workers should be at least 1!");
        }
        if (port < 0) {
            throw new IllegalArgumentException("Port can't be negative!");
        }
        if (handlerFactory == null) {
            throw new NullPointerException("Please specify handler factory!");
        }
        this.port = port;
        this.workerCount = workerCount;
        this.handlerFactory = handlerFactory;
    }

    public int getPort() {
        return this.port;
    }

    public TcpServerHandlerFactory getHandlerFactory() {
        return this.handlerFactory;
    }

    public int getWorkerCount() {
        return this.workerCount;
    }
}

