/*
 * Decompiled with CFR 0.152.
 */
package com.github.terma.javaniotcpproxy;

import com.github.terma.javaniotcpproxy.TcpProxy;
import com.github.terma.javaniotcpproxy.TcpProxyConfig;
import com.github.terma.javaniotcpproxy.TcpProxyConfigParser;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;

public class TcpProxyRunner {
    private static final Logger LOGGER = Logger.getAnonymousLogger();

    public static void main(String[] args) {
        if (args.length != 1) {
            System.err.println("Please specify path to config file!");
            System.exit(1);
        }
        Properties properties = new Properties();
        try {
            properties.load(new FileInputStream(args[0]));
        }
        catch (IOException exception) {
            if (LOGGER.isLoggable(Level.SEVERE)) {
                LOGGER.log(Level.SEVERE, "Can't load properties from " + args[0], exception);
            }
            System.exit(1);
        }
        List<TcpProxyConfig> configs = TcpProxyConfigParser.parse(properties);
        if (LOGGER.isLoggable(Level.INFO)) {
            LOGGER.info("Starting TcpProxy with " + configs.size() + " connectors");
        }
        int cores = Runtime.getRuntime().availableProcessors();
        if (LOGGER.isLoggable(Level.INFO)) {
            LOGGER.info("TcpProxy detected " + cores + " core" + (cores > 1 ? "s" : ""));
        }
        int workerCount = Math.max(cores / configs.size(), 1);
        if (LOGGER.isLoggable(Level.INFO)) {
            LOGGER.info("TcpProxy will use " + workerCount + " workers per connector");
        }
        for (TcpProxyConfig config : configs) {
            config.setWorkerCount(workerCount);
            new TcpProxy(config).start();
        }
        if (LOGGER.isLoggable(Level.INFO)) {
            LOGGER.info("TcpProxy started");
        }
    }
}

