/*
 * Decompiled with CFR 0.152.
 */
package com.github.terma.javaniotcpproxy;

import com.github.terma.javaniotcpproxy.StaticTcpProxyConfig;
import com.github.terma.javaniotcpproxy.TcpProxyConfig;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;

public class TcpProxyConfigParser {
    public static List<TcpProxyConfig> parse(Properties properties) {
        HashSet<String> proxyNames = new HashSet<String>();
        ArrayList<String> propertySet = Collections.list(properties.propertyNames());
        for (String propertyName : propertySet) {
            int dotIndex = propertyName.lastIndexOf(46);
            if (dotIndex == -1) {
                throw new IllegalArgumentException("Invalid property " + propertyName + " should be <proxy name>.localPort|remotePort|remoteHost");
            }
            proxyNames.add(propertyName.substring(0, dotIndex));
        }
        if (proxyNames.isEmpty()) {
            throw new IllegalArgumentException("Please specify at least one proxy.");
        }
        ArrayList<TcpProxyConfig> tcpProxyConfigs = new ArrayList<TcpProxyConfig>();
        for (String proxyName : proxyNames) {
            int localPort = TcpProxyConfigParser.findIntegerProperty(properties, proxyName + ".localPort");
            int remotePort = TcpProxyConfigParser.findIntegerProperty(properties, proxyName + ".remotePort");
            String remoteHost = TcpProxyConfigParser.findProperty(properties, proxyName + ".remoteHost");
            tcpProxyConfigs.add(new StaticTcpProxyConfig(localPort, remoteHost, remotePort));
        }
        return tcpProxyConfigs;
    }

    private static int findIntegerProperty(Properties properties, String key) {
        String value = TcpProxyConfigParser.findProperty(properties, key);
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException exception) {
            throw new IllegalArgumentException("Invalid integer " + key + " = " + value, exception);
        }
    }

    private static String findProperty(Properties properties, String key) {
        String value = properties.getProperty(key);
        if (value == null) {
            throw new IllegalArgumentException("Please specify " + key);
        }
        return value;
    }
}

