/*
 * Decompiled with CFR 0.152.
 */
package com.github.terma.javaniotcpproxy;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.SocketChannel;

class TcpProxyBuffer {
    private static final int BUFFER_SIZE = 1000;
    private final ByteBuffer buffer = ByteBuffer.allocateDirect(1000);
    private BufferState state = BufferState.READY_TO_WRITE;

    TcpProxyBuffer() {
    }

    public boolean isReadyToRead() {
        return this.state == BufferState.READY_TO_READ;
    }

    public boolean isReadyToWrite() {
        return this.state == BufferState.READY_TO_WRITE;
    }

    public void writeFrom(SocketChannel channel) throws IOException {
        int read = channel.read(this.buffer);
        if (read == -1) {
            throw new ClosedChannelException();
        }
        if (read > 0) {
            this.buffer.flip();
            this.state = BufferState.READY_TO_READ;
        }
    }

    public void writeTo(SocketChannel channel) throws IOException {
        channel.write(this.buffer);
        if (this.buffer.remaining() == 0) {
            this.buffer.clear();
            this.state = BufferState.READY_TO_WRITE;
        }
    }

    private static enum BufferState {
        READY_TO_WRITE,
        READY_TO_READ;

    }
}

