/*
 * Decompiled with CFR 0.152.
 */
package com.github.sonus21.rqueue.web.service.impl;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.sonus21.rqueue.dao.RqueueJobDao;
import com.github.sonus21.rqueue.exception.ProcessingException;
import com.github.sonus21.rqueue.models.db.CheckinMessage;
import com.github.sonus21.rqueue.models.db.RqueueJob;
import com.github.sonus21.rqueue.models.response.DataViewResponse;
import com.github.sonus21.rqueue.models.response.TableColumn;
import com.github.sonus21.rqueue.models.response.TableRow;
import com.github.sonus21.rqueue.utils.DateTimeUtils;
import com.github.sonus21.rqueue.utils.StringUtils;
import com.github.sonus21.rqueue.web.service.RqueueJobService;
import java.io.Serializable;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class RqueueJobServiceImpl
implements RqueueJobService {
    private final RqueueJobDao rqueueJobDao;
    private final ObjectMapper objectMapper;

    @Autowired
    public RqueueJobServiceImpl(RqueueJobDao rqueueJobDao) {
        this.rqueueJobDao = rqueueJobDao;
        this.objectMapper = new ObjectMapper();
    }

    private TableRow getTableRow(RqueueJob job) throws ProcessingException {
        LinkedList<TableColumn> columns = new LinkedList<TableColumn>();
        columns.add(new TableColumn((Serializable)((Object)job.getId())));
        columns.add(new TableColumn((Serializable)((Object)String.format("%s/%s", DateTimeUtils.formatMilliToString(job.getCreatedAt()), DateTimeUtils.formatMilliToString(job.getUpdatedAt())))));
        if (job.getLastCheckinAt() == 0L) {
            columns.add(new TableColumn((Serializable)((Object)"")));
        } else {
            long timeDifference = System.currentTimeMillis() - job.getLastCheckinAt();
            columns.add(new TableColumn((Serializable)((Object)(DateTimeUtils.milliToHumanRepresentation(timeDifference) + " Ago"))));
        }
        if (!StringUtils.isEmpty(job.getError())) {
            columns.add(new TableColumn((Serializable)((Object)job.getError())));
        } else {
            columns.add(new TableColumn((Serializable)((Object)"")));
        }
        columns.add(new TableColumn((Serializable)((Object)job.getStatus())));
        List<CheckinMessage> checkinMessages = job.getCheckins();
        if (CollectionUtils.isEmpty(checkinMessages)) {
            columns.add(new TableColumn((Serializable)((Object)"")));
        } else {
            try {
                String data = this.objectMapper.writeValueAsString(job.getCheckins());
                columns.add(new TableColumn((Serializable)((Object)data)));
            }
            catch (JsonProcessingException e) {
                throw new ProcessingException(e.getMessage(), (Object)e);
            }
        }
        return new TableRow(columns);
    }

    @Override
    public DataViewResponse getJobs(String messageId) throws ProcessingException {
        List<RqueueJob> jobList = this.rqueueJobDao.finByMessageId(messageId);
        DataViewResponse response = new DataViewResponse();
        if (jobList.isEmpty()) {
            response.setCode(0);
            response.setMessage("No jobs found");
        } else {
            jobList.sort((o1, o2) -> {
                long diff = o1.getUpdatedAt() - o2.getUpdatedAt();
                if (diff == 0L) {
                    return 0;
                }
                if (diff > 0L) {
                    return 1;
                }
                return -1;
            });
            response.setHeaders(Arrays.asList("Id", "StartTime/EndTime", "Last Checkin", "Error", "Status", "CheckIns"));
            for (RqueueJob job : jobList) {
                response.addRow(this.getTableRow(job));
            }
        }
        return response;
    }
}

