/*
 * Decompiled with CFR 0.152.
 */
package com.github.sonus21.rqueue.utils;

import com.github.sonus21.rqueue.utils.StringUtils;
import org.slf4j.Logger;
import org.slf4j.event.Level;

public class PrefixLogger {
    private final Logger log;
    private final String prefix;

    public PrefixLogger(Logger log, String groupName) {
        this.log = log;
        this.prefix = StringUtils.isEmpty(groupName) ? "" : "[" + groupName + "] ";
    }

    private boolean shouldLog(Level level) {
        if (level == Level.DEBUG && !this.log.isDebugEnabled()) {
            return false;
        }
        if (level == Level.ERROR && !this.log.isErrorEnabled()) {
            return false;
        }
        if (level == Level.INFO && !this.log.isInfoEnabled()) {
            return false;
        }
        if (level == Level.WARN && !this.log.isWarnEnabled()) {
            return false;
        }
        return level != Level.TRACE || this.log.isTraceEnabled();
    }

    public void log(Level level, String msg, Throwable t, Object ... arguments) {
        if (!this.shouldLog(level)) {
            return;
        }
        if (t == null) {
            this.logMessage(level, this.prefix + msg, arguments);
        } else {
            Object[] objects1 = new Object[arguments.length + 1];
            System.arraycopy(arguments, 0, objects1, 0, arguments.length);
            objects1[objects1.length - 1] = t;
            this.logMessage(level, this.prefix + msg, objects1);
        }
    }

    private void logMessage(Level level, String txt, Object ... arguments) {
        switch (level) {
            case INFO: {
                this.log.info(txt, arguments);
                break;
            }
            case WARN: {
                this.log.warn(txt, arguments);
                break;
            }
            case DEBUG: {
                this.log.debug(txt, arguments);
                break;
            }
            case ERROR: {
                this.log.error(txt, arguments);
                break;
            }
            default: {
                this.log.trace(txt, arguments);
            }
        }
    }

    public boolean isDebugEnabled() {
        return this.log.isDebugEnabled();
    }

    public boolean isWarningEnabled() {
        return this.log.isWarnEnabled();
    }
}

