/*
 * Decompiled with CFR 0.152.
 */
package com.github.sonus21.rqueue.models.request;

import com.github.sonus21.rqueue.config.RqueueWebConfig;
import com.github.sonus21.rqueue.models.enums.DataType;
import com.github.sonus21.rqueue.utils.StringUtils;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;

public class MessageMoveRequest
implements Serializable {
    private static final long serialVersionUID = -5105668034442269108L;
    private String src;
    private DataType srcType;
    private String dst;
    private DataType dstType;
    private Map<String, Serializable> others = new HashMap<String, Serializable>();

    public MessageMoveRequest(String src, DataType srcType, String dst, DataType dstType) {
        this.setSrc(src);
        this.setSrcType(srcType);
        this.setDst(dst);
        this.setDstType(dstType);
    }

    public String validationMessage() {
        this.src = StringUtils.clean(this.src);
        if (StringUtils.isEmpty(this.src)) {
            return "Source cannot be empty.";
        }
        this.dst = StringUtils.clean(this.dst);
        if (StringUtils.isEmpty(this.dst)) {
            return "Destination cannot be empty.";
        }
        if (this.src.equals(this.dst)) {
            return "Source and Destination cannot be same.";
        }
        if (DataType.isUnknown(this.srcType)) {
            return "Source data type cannot be unknown.";
        }
        if (DataType.isUnknown(this.dstType)) {
            return "Destination data type cannot be unknown.";
        }
        List<DataType> dataTypes = DataType.getEnabledDataTypes();
        if (!dataTypes.contains((Object)this.srcType)) {
            return "Source data type is not supported.";
        }
        if (!dataTypes.contains((Object)this.dstType)) {
            return "Destination data type is not supported.";
        }
        return null;
    }

    public int getMessageCount(RqueueWebConfig rqueueWebConfig) {
        if (this.others == null) {
            this.others = new HashMap<String, Serializable>();
            return rqueueWebConfig.getMaxMessageMoveCount();
        }
        Integer requestMessageCount = (Integer)this.others.get("maxMessages");
        if (requestMessageCount == null) {
            return rqueueWebConfig.getMaxMessageMoveCount();
        }
        return requestMessageCount;
    }

    @Generated
    public String getSrc() {
        return this.src;
    }

    @Generated
    public DataType getSrcType() {
        return this.srcType;
    }

    @Generated
    public String getDst() {
        return this.dst;
    }

    @Generated
    public DataType getDstType() {
        return this.dstType;
    }

    @Generated
    public Map<String, Serializable> getOthers() {
        return this.others;
    }

    @Generated
    public void setSrc(String src) {
        this.src = src;
    }

    @Generated
    public void setSrcType(DataType srcType) {
        this.srcType = srcType;
    }

    @Generated
    public void setDst(String dst) {
        this.dst = dst;
    }

    @Generated
    public void setDstType(DataType dstType) {
        this.dstType = dstType;
    }

    @Generated
    public void setOthers(Map<String, Serializable> others) {
        this.others = others;
    }

    @Generated
    public MessageMoveRequest() {
    }

    @Generated
    public String toString() {
        return "MessageMoveRequest(src=" + this.getSrc() + ", srcType=" + (Object)((Object)this.getSrcType()) + ", dst=" + this.getDst() + ", dstType=" + (Object)((Object)this.getDstType()) + ", others=" + this.getOthers() + ")";
    }
}

