/*
 * Decompiled with CFR 0.152.
 */
package com.github.sonus21.rqueue.models.enums;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;

public enum DataType {
    NONE("Select Data Type", false),
    LIST("List", true),
    ZSET("Priority Queue", true),
    KEY("Simple key/value", false),
    SET("Set", false);

    private final String description;
    private final boolean enabled;

    public static DataType convertDataType(org.springframework.data.redis.connection.DataType type) {
        switch (type) {
            case LIST: {
                return LIST;
            }
            case ZSET: {
                return ZSET;
            }
            case SET: {
                return SET;
            }
            case STRING: {
                return KEY;
            }
        }
        return NONE;
    }

    public static List<DataType> getEnabledDataTypes() {
        return Arrays.stream(DataType.values()).filter(DataType::isEnabled).collect(Collectors.toList());
    }

    public static boolean isUnknown(DataType type) {
        return type == null || type == NONE;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public boolean isEnabled() {
        return this.enabled;
    }

    @Generated
    private DataType(String description, boolean enabled) {
        this.description = description;
        this.enabled = enabled;
    }
}

