/*
 * Decompiled with CFR 0.152.
 */
package com.github.sonus21.rqueue.models.db;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.github.sonus21.rqueue.core.RqueueMessage;
import com.github.sonus21.rqueue.models.SerializableBase;
import com.github.sonus21.rqueue.models.db.CheckinMessage;
import com.github.sonus21.rqueue.models.db.Execution;
import com.github.sonus21.rqueue.models.db.MessageMetadata;
import com.github.sonus21.rqueue.models.enums.ExecutionStatus;
import com.github.sonus21.rqueue.models.enums.JobStatus;
import com.github.sonus21.rqueue.utils.ExceptionUtils;
import java.io.Serializable;
import java.util.LinkedList;
import java.util.List;
import lombok.Generated;

public class RqueueJob
extends SerializableBase {
    private static final long serialVersionUID = 6219118148061766036L;
    private String id;
    private String messageId;
    private RqueueMessage rqueueMessage;
    private MessageMetadata messageMetadata;
    private JobStatus status;
    private long lastCheckinAt;
    private List<CheckinMessage> checkins;
    private List<Execution> executions;
    private String error;
    @JsonIgnore
    private Throwable exception;
    private long createdAt;
    private long updatedAt;

    public RqueueJob(String id, RqueueMessage rqueueMessage, MessageMetadata messageMetadata, Throwable error) {
        this(id, rqueueMessage.getId(), rqueueMessage, messageMetadata, JobStatus.CREATED, 0L, new LinkedList<CheckinMessage>(), new LinkedList<Execution>(), null, null, System.currentTimeMillis(), System.currentTimeMillis());
        if (error != null) {
            this.updateError(error);
            this.status = JobStatus.FAILED;
        }
    }

    private void updateError(Throwable e) {
        this.exception = e;
        this.error = ExceptionUtils.getTraceback(e, 3000);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkIn(Serializable message) {
        RqueueJob rqueueJob = this;
        synchronized (rqueueJob) {
            long checkInTime = System.currentTimeMillis();
            this.checkins.add(new CheckinMessage(message, checkInTime));
            this.lastCheckinAt = Math.max(checkInTime, this.lastCheckinAt);
            this.updatedAt = Math.max(checkInTime, this.updatedAt);
            this.notifyAll();
        }
    }

    public Execution startNewExecution() {
        Execution execution = new Execution(System.currentTimeMillis(), 0L, null, null, ExecutionStatus.IN_PROGRESS);
        this.executions.add(execution);
        return execution;
    }

    public void updateExecutionStatus(ExecutionStatus status, Throwable e) {
        Execution execution = this.executions.get(this.executions.size() - 1);
        execution.setStatus(status);
        execution.setError(ExceptionUtils.getTraceback(e, 3000));
        execution.setException(e);
        execution.setEndTime(System.currentTimeMillis());
        if (e != null && this.exception == null) {
            this.updateError(e);
        }
    }

    @Generated
    public String getId() {
        return this.id;
    }

    @Generated
    public String getMessageId() {
        return this.messageId;
    }

    @Generated
    public RqueueMessage getRqueueMessage() {
        return this.rqueueMessage;
    }

    @Generated
    public MessageMetadata getMessageMetadata() {
        return this.messageMetadata;
    }

    @Generated
    public JobStatus getStatus() {
        return this.status;
    }

    @Generated
    public long getLastCheckinAt() {
        return this.lastCheckinAt;
    }

    @Generated
    public List<CheckinMessage> getCheckins() {
        return this.checkins;
    }

    @Generated
    public List<Execution> getExecutions() {
        return this.executions;
    }

    @Generated
    public String getError() {
        return this.error;
    }

    @Generated
    public Throwable getException() {
        return this.exception;
    }

    @Generated
    public long getCreatedAt() {
        return this.createdAt;
    }

    @Generated
    public long getUpdatedAt() {
        return this.updatedAt;
    }

    @Generated
    public void setId(String id) {
        this.id = id;
    }

    @Generated
    public void setMessageId(String messageId) {
        this.messageId = messageId;
    }

    @Generated
    public void setRqueueMessage(RqueueMessage rqueueMessage) {
        this.rqueueMessage = rqueueMessage;
    }

    @Generated
    public void setMessageMetadata(MessageMetadata messageMetadata) {
        this.messageMetadata = messageMetadata;
    }

    @Generated
    public void setStatus(JobStatus status) {
        this.status = status;
    }

    @Generated
    public void setLastCheckinAt(long lastCheckinAt) {
        this.lastCheckinAt = lastCheckinAt;
    }

    @Generated
    public void setCheckins(List<CheckinMessage> checkins) {
        this.checkins = checkins;
    }

    @Generated
    public void setExecutions(List<Execution> executions) {
        this.executions = executions;
    }

    @Generated
    public void setError(String error) {
        this.error = error;
    }

    @Generated
    public void setException(Throwable exception) {
        this.exception = exception;
    }

    @Generated
    public void setCreatedAt(long createdAt) {
        this.createdAt = createdAt;
    }

    @Generated
    public void setUpdatedAt(long updatedAt) {
        this.updatedAt = updatedAt;
    }

    @Generated
    public RqueueJob() {
    }

    @Generated
    public RqueueJob(String id, String messageId, RqueueMessage rqueueMessage, MessageMetadata messageMetadata, JobStatus status, long lastCheckinAt, List<CheckinMessage> checkins, List<Execution> executions, String error, Throwable exception, long createdAt, long updatedAt) {
        this.id = id;
        this.messageId = messageId;
        this.rqueueMessage = rqueueMessage;
        this.messageMetadata = messageMetadata;
        this.status = status;
        this.lastCheckinAt = lastCheckinAt;
        this.checkins = checkins;
        this.executions = executions;
        this.error = error;
        this.exception = exception;
        this.createdAt = createdAt;
        this.updatedAt = updatedAt;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RqueueJob)) {
            return false;
        }
        RqueueJob other = (RqueueJob)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$messageId = this.getMessageId();
        String other$messageId = other.getMessageId();
        if (this$messageId == null ? other$messageId != null : !this$messageId.equals(other$messageId)) {
            return false;
        }
        RqueueMessage this$rqueueMessage = this.getRqueueMessage();
        RqueueMessage other$rqueueMessage = other.getRqueueMessage();
        if (this$rqueueMessage == null ? other$rqueueMessage != null : !((Object)this$rqueueMessage).equals(other$rqueueMessage)) {
            return false;
        }
        MessageMetadata this$messageMetadata = this.getMessageMetadata();
        MessageMetadata other$messageMetadata = other.getMessageMetadata();
        if (this$messageMetadata == null ? other$messageMetadata != null : !((Object)this$messageMetadata).equals(other$messageMetadata)) {
            return false;
        }
        JobStatus this$status = this.getStatus();
        JobStatus other$status = other.getStatus();
        if (this$status == null ? other$status != null : !((Object)((Object)this$status)).equals((Object)other$status)) {
            return false;
        }
        if (this.getLastCheckinAt() != other.getLastCheckinAt()) {
            return false;
        }
        List<CheckinMessage> this$checkins = this.getCheckins();
        List<CheckinMessage> other$checkins = other.getCheckins();
        if (this$checkins == null ? other$checkins != null : !((Object)this$checkins).equals(other$checkins)) {
            return false;
        }
        List<Execution> this$executions = this.getExecutions();
        List<Execution> other$executions = other.getExecutions();
        if (this$executions == null ? other$executions != null : !((Object)this$executions).equals(other$executions)) {
            return false;
        }
        String this$error = this.getError();
        String other$error = other.getError();
        if (this$error == null ? other$error != null : !this$error.equals(other$error)) {
            return false;
        }
        Throwable this$exception = this.getException();
        Throwable other$exception = other.getException();
        if (this$exception == null ? other$exception != null : !this$exception.equals(other$exception)) {
            return false;
        }
        if (this.getCreatedAt() != other.getCreatedAt()) {
            return false;
        }
        return this.getUpdatedAt() == other.getUpdatedAt();
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof RqueueJob;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $messageId = this.getMessageId();
        result = result * 59 + ($messageId == null ? 43 : $messageId.hashCode());
        RqueueMessage $rqueueMessage = this.getRqueueMessage();
        result = result * 59 + ($rqueueMessage == null ? 43 : ((Object)$rqueueMessage).hashCode());
        MessageMetadata $messageMetadata = this.getMessageMetadata();
        result = result * 59 + ($messageMetadata == null ? 43 : ((Object)$messageMetadata).hashCode());
        JobStatus $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : ((Object)((Object)$status)).hashCode());
        long $lastCheckinAt = this.getLastCheckinAt();
        result = result * 59 + (int)($lastCheckinAt >>> 32 ^ $lastCheckinAt);
        List<CheckinMessage> $checkins = this.getCheckins();
        result = result * 59 + ($checkins == null ? 43 : ((Object)$checkins).hashCode());
        List<Execution> $executions = this.getExecutions();
        result = result * 59 + ($executions == null ? 43 : ((Object)$executions).hashCode());
        String $error = this.getError();
        result = result * 59 + ($error == null ? 43 : $error.hashCode());
        Throwable $exception = this.getException();
        result = result * 59 + ($exception == null ? 43 : $exception.hashCode());
        long $createdAt = this.getCreatedAt();
        result = result * 59 + (int)($createdAt >>> 32 ^ $createdAt);
        long $updatedAt = this.getUpdatedAt();
        result = result * 59 + (int)($updatedAt >>> 32 ^ $updatedAt);
        return result;
    }

    @Generated
    public String toString() {
        return "RqueueJob(super=" + super.toString() + ", id=" + this.getId() + ", messageId=" + this.getMessageId() + ", rqueueMessage=" + this.getRqueueMessage() + ", messageMetadata=" + this.getMessageMetadata() + ", status=" + (Object)((Object)this.getStatus()) + ", lastCheckinAt=" + this.getLastCheckinAt() + ", checkins=" + this.getCheckins() + ", executions=" + this.getExecutions() + ", error=" + this.getError() + ", exception=" + this.getException() + ", createdAt=" + this.getCreatedAt() + ", updatedAt=" + this.getUpdatedAt() + ")";
    }
}

