/*
 * Decompiled with CFR 0.152.
 */
package com.github.sonus21.rqueue.models.db;

import com.github.sonus21.rqueue.core.RqueueMessage;
import com.github.sonus21.rqueue.core.support.RqueueMessageUtils;
import com.github.sonus21.rqueue.models.SerializableBase;
import com.github.sonus21.rqueue.models.enums.MessageStatus;
import lombok.Generated;

public class MessageMetadata
extends SerializableBase {
    private static final long serialVersionUID = 4200184682879443328L;
    private String id;
    private long totalExecutionTime;
    private boolean deleted;
    private Long deletedOn;
    private RqueueMessage rqueueMessage;
    private MessageStatus status;

    public MessageMetadata(String id, MessageStatus messageStatus) {
        this.id = id;
        this.status = messageStatus;
    }

    public MessageMetadata(RqueueMessage rqueueMessage, MessageStatus messageStatus) {
        this.id = RqueueMessageUtils.getMessageMetaId(rqueueMessage.getQueueName(), rqueueMessage.getId());
        this.rqueueMessage = rqueueMessage;
        this.status = messageStatus;
    }

    @Generated
    public String getId() {
        return this.id;
    }

    @Generated
    public long getTotalExecutionTime() {
        return this.totalExecutionTime;
    }

    @Generated
    public boolean isDeleted() {
        return this.deleted;
    }

    @Generated
    public Long getDeletedOn() {
        return this.deletedOn;
    }

    @Generated
    public RqueueMessage getRqueueMessage() {
        return this.rqueueMessage;
    }

    @Generated
    public MessageStatus getStatus() {
        return this.status;
    }

    @Generated
    public void setId(String id) {
        this.id = id;
    }

    @Generated
    public void setTotalExecutionTime(long totalExecutionTime) {
        this.totalExecutionTime = totalExecutionTime;
    }

    @Generated
    public void setDeleted(boolean deleted) {
        this.deleted = deleted;
    }

    @Generated
    public void setDeletedOn(Long deletedOn) {
        this.deletedOn = deletedOn;
    }

    @Generated
    public void setRqueueMessage(RqueueMessage rqueueMessage) {
        this.rqueueMessage = rqueueMessage;
    }

    @Generated
    public void setStatus(MessageStatus status) {
        this.status = status;
    }

    @Generated
    public MessageMetadata(String id, long totalExecutionTime, boolean deleted, Long deletedOn, RqueueMessage rqueueMessage, MessageStatus status) {
        this.id = id;
        this.totalExecutionTime = totalExecutionTime;
        this.deleted = deleted;
        this.deletedOn = deletedOn;
        this.rqueueMessage = rqueueMessage;
        this.status = status;
    }

    @Generated
    public MessageMetadata() {
    }

    @Generated
    public String toString() {
        return "MessageMetadata(id=" + this.getId() + ", totalExecutionTime=" + this.getTotalExecutionTime() + ", deleted=" + this.isDeleted() + ", deletedOn=" + this.getDeletedOn() + ", rqueueMessage=" + this.getRqueueMessage() + ", status=" + (Object)((Object)this.getStatus()) + ")";
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MessageMetadata)) {
            return false;
        }
        MessageMetadata other = (MessageMetadata)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        if (this.getTotalExecutionTime() != other.getTotalExecutionTime()) {
            return false;
        }
        if (this.isDeleted() != other.isDeleted()) {
            return false;
        }
        Long this$deletedOn = this.getDeletedOn();
        Long other$deletedOn = other.getDeletedOn();
        if (this$deletedOn == null ? other$deletedOn != null : !((Object)this$deletedOn).equals(other$deletedOn)) {
            return false;
        }
        RqueueMessage this$rqueueMessage = this.getRqueueMessage();
        RqueueMessage other$rqueueMessage = other.getRqueueMessage();
        if (this$rqueueMessage == null ? other$rqueueMessage != null : !((Object)this$rqueueMessage).equals(other$rqueueMessage)) {
            return false;
        }
        MessageStatus this$status = this.getStatus();
        MessageStatus other$status = other.getStatus();
        return !(this$status == null ? other$status != null : !((Object)((Object)this$status)).equals((Object)other$status));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof MessageMetadata;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        long $totalExecutionTime = this.getTotalExecutionTime();
        result = result * 59 + (int)($totalExecutionTime >>> 32 ^ $totalExecutionTime);
        result = result * 59 + (this.isDeleted() ? 79 : 97);
        Long $deletedOn = this.getDeletedOn();
        result = result * 59 + ($deletedOn == null ? 43 : ((Object)$deletedOn).hashCode());
        RqueueMessage $rqueueMessage = this.getRqueueMessage();
        result = result * 59 + ($rqueueMessage == null ? 43 : ((Object)$rqueueMessage).hashCode());
        MessageStatus $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : ((Object)((Object)$status)).hashCode());
        return result;
    }
}

