/*
 * Decompiled with CFR 0.152.
 */
package com.github.sonus21.rqueue.listener;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.github.sonus21.rqueue.models.Concurrency;
import com.github.sonus21.rqueue.models.SerializableBase;
import com.github.sonus21.rqueue.models.db.DeadLetterQueue;
import com.github.sonus21.rqueue.models.db.QueueConfig;
import com.github.sonus21.rqueue.utils.PriorityUtils;
import com.github.sonus21.rqueue.utils.StringUtils;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import lombok.Generated;

public class QueueDetail
extends SerializableBase {
    private final long visibilityTimeout;
    private static final long serialVersionUID = 9153752084449974622L;
    private final String name;
    private final int numRetry;
    private final QueueType type;
    private final String queueName;
    private final String deadLetterQueueName;
    private final boolean deadLetterConsumerEnabled;
    private final String processingQueueName;
    private final String processingQueueChannelName;
    private final String delayedQueueName;
    private final String delayedQueueChannelName;
    private final boolean active;
    private final Concurrency concurrency;
    private final boolean systemGenerated;
    private Map<String, Integer> priority;
    private String priorityGroup;

    public boolean isDlqSet() {
        return !StringUtils.isEmpty(this.deadLetterQueueName);
    }

    @JsonIgnore
    public DeadLetterQueue getDeadLetterQueue() {
        return new DeadLetterQueue(this.deadLetterQueueName, this.deadLetterConsumerEnabled);
    }

    public QueueConfig toConfig() {
        QueueConfig queueConfig = QueueConfig.builder().name(this.name).numRetry(this.numRetry).queueName(this.queueName).delayedQueueName(this.delayedQueueName).processingQueueName(this.processingQueueName).visibilityTimeout(this.visibilityTimeout).createdOn(System.currentTimeMillis()).updatedOn(System.currentTimeMillis()).deadLetterQueues(new LinkedList<DeadLetterQueue>()).concurrency(this.concurrency.toMinMax()).priority(Collections.unmodifiableMap(this.priority)).priorityGroup(this.priorityGroup).systemGenerated(this.systemGenerated).build();
        if (this.isDlqSet()) {
            queueConfig.addDeadLetterQueue(this.getDeadLetterQueue());
        }
        return queueConfig;
    }

    List<QueueDetail> expandQueueDetail(boolean addDefault, int priority) {
        ArrayList<QueueDetail> queueDetails = new ArrayList<QueueDetail>();
        for (Map.Entry<String, Integer> entry : this.getPriority().entrySet()) {
            QueueDetail cloneQueueDetail = this.cloneQueueDetail(entry.getKey(), entry.getValue(), true, this.name);
            queueDetails.add(cloneQueueDetail);
        }
        if (addDefault) {
            int defaultPriority = priority;
            if (defaultPriority == -1) {
                ArrayList<Integer> priorities = new ArrayList<Integer>(this.getPriority().values());
                priorities.sort(Comparator.comparingInt(o -> o));
                defaultPriority = (Integer)priorities.get(priorities.size() / 2);
            }
            HashMap<String, Integer> priorityMap = new HashMap<String, Integer>(this.priority);
            priorityMap.put("DEFAULT_PRIORITY", defaultPriority);
            this.priority = Collections.unmodifiableMap(priorityMap);
            this.priorityGroup = this.name;
            queueDetails.add(this);
        }
        return queueDetails;
    }

    private QueueDetail cloneQueueDetail(String priorityName, Integer priority, boolean systemGenerated, String priorityGroup) {
        if (priority == null || priorityName == null) {
            throw new IllegalStateException("priority name is null");
        }
        String suffix = PriorityUtils.getSuffix(priorityName);
        return QueueDetail.builder().numRetry(this.numRetry).visibilityTimeout(this.visibilityTimeout).deadLetterQueueName(this.deadLetterQueueName).deadLetterConsumerEnabled(this.deadLetterConsumerEnabled).name(this.name + suffix).queueName(this.queueName + suffix).processingQueueName(this.processingQueueName + suffix).processingQueueChannelName(this.processingQueueChannelName + suffix).delayedQueueName(this.delayedQueueName + suffix).delayedQueueChannelName(this.delayedQueueChannelName + suffix).active(this.active).systemGenerated(systemGenerated).priorityGroup(priorityGroup).concurrency(this.concurrency).priority(Collections.singletonMap("DEFAULT_PRIORITY", priority)).build();
    }

    public Duration visibilityDuration() {
        return Duration.ofMillis(this.visibilityTimeout);
    }

    @Generated
    private static QueueType $default$type() {
        return QueueType.QUEUE;
    }

    @Generated
    QueueDetail(long visibilityTimeout, String name, int numRetry, QueueType type, String queueName, String deadLetterQueueName, boolean deadLetterConsumerEnabled, String processingQueueName, String processingQueueChannelName, String delayedQueueName, String delayedQueueChannelName, boolean active, Concurrency concurrency, boolean systemGenerated, Map<String, Integer> priority, String priorityGroup) {
        this.visibilityTimeout = visibilityTimeout;
        this.name = name;
        this.numRetry = numRetry;
        this.type = type;
        this.queueName = queueName;
        this.deadLetterQueueName = deadLetterQueueName;
        this.deadLetterConsumerEnabled = deadLetterConsumerEnabled;
        this.processingQueueName = processingQueueName;
        this.processingQueueChannelName = processingQueueChannelName;
        this.delayedQueueName = delayedQueueName;
        this.delayedQueueChannelName = delayedQueueChannelName;
        this.active = active;
        this.concurrency = concurrency;
        this.systemGenerated = systemGenerated;
        this.priority = priority;
        this.priorityGroup = priorityGroup;
    }

    @Generated
    public static QueueDetailBuilder builder() {
        return new QueueDetailBuilder();
    }

    @Generated
    public long getVisibilityTimeout() {
        return this.visibilityTimeout;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public int getNumRetry() {
        return this.numRetry;
    }

    @Generated
    public QueueType getType() {
        return this.type;
    }

    @Generated
    public String getQueueName() {
        return this.queueName;
    }

    @Generated
    public String getDeadLetterQueueName() {
        return this.deadLetterQueueName;
    }

    @Generated
    public boolean isDeadLetterConsumerEnabled() {
        return this.deadLetterConsumerEnabled;
    }

    @Generated
    public String getProcessingQueueName() {
        return this.processingQueueName;
    }

    @Generated
    public String getProcessingQueueChannelName() {
        return this.processingQueueChannelName;
    }

    @Generated
    public String getDelayedQueueName() {
        return this.delayedQueueName;
    }

    @Generated
    public String getDelayedQueueChannelName() {
        return this.delayedQueueChannelName;
    }

    @Generated
    public boolean isActive() {
        return this.active;
    }

    @Generated
    public Concurrency getConcurrency() {
        return this.concurrency;
    }

    @Generated
    public boolean isSystemGenerated() {
        return this.systemGenerated;
    }

    @Generated
    public Map<String, Integer> getPriority() {
        return this.priority;
    }

    @Generated
    public String getPriorityGroup() {
        return this.priorityGroup;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof QueueDetail)) {
            return false;
        }
        QueueDetail other = (QueueDetail)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.getVisibilityTimeout() != other.getVisibilityTimeout()) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        if (this.getNumRetry() != other.getNumRetry()) {
            return false;
        }
        QueueType this$type = this.getType();
        QueueType other$type = other.getType();
        if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
            return false;
        }
        String this$queueName = this.getQueueName();
        String other$queueName = other.getQueueName();
        if (this$queueName == null ? other$queueName != null : !this$queueName.equals(other$queueName)) {
            return false;
        }
        String this$deadLetterQueueName = this.getDeadLetterQueueName();
        String other$deadLetterQueueName = other.getDeadLetterQueueName();
        if (this$deadLetterQueueName == null ? other$deadLetterQueueName != null : !this$deadLetterQueueName.equals(other$deadLetterQueueName)) {
            return false;
        }
        if (this.isDeadLetterConsumerEnabled() != other.isDeadLetterConsumerEnabled()) {
            return false;
        }
        String this$processingQueueName = this.getProcessingQueueName();
        String other$processingQueueName = other.getProcessingQueueName();
        if (this$processingQueueName == null ? other$processingQueueName != null : !this$processingQueueName.equals(other$processingQueueName)) {
            return false;
        }
        String this$processingQueueChannelName = this.getProcessingQueueChannelName();
        String other$processingQueueChannelName = other.getProcessingQueueChannelName();
        if (this$processingQueueChannelName == null ? other$processingQueueChannelName != null : !this$processingQueueChannelName.equals(other$processingQueueChannelName)) {
            return false;
        }
        String this$delayedQueueName = this.getDelayedQueueName();
        String other$delayedQueueName = other.getDelayedQueueName();
        if (this$delayedQueueName == null ? other$delayedQueueName != null : !this$delayedQueueName.equals(other$delayedQueueName)) {
            return false;
        }
        String this$delayedQueueChannelName = this.getDelayedQueueChannelName();
        String other$delayedQueueChannelName = other.getDelayedQueueChannelName();
        if (this$delayedQueueChannelName == null ? other$delayedQueueChannelName != null : !this$delayedQueueChannelName.equals(other$delayedQueueChannelName)) {
            return false;
        }
        if (this.isActive() != other.isActive()) {
            return false;
        }
        Concurrency this$concurrency = this.getConcurrency();
        Concurrency other$concurrency = other.getConcurrency();
        if (this$concurrency == null ? other$concurrency != null : !((Object)this$concurrency).equals(other$concurrency)) {
            return false;
        }
        if (this.isSystemGenerated() != other.isSystemGenerated()) {
            return false;
        }
        Map<String, Integer> this$priority = this.getPriority();
        Map<String, Integer> other$priority = other.getPriority();
        if (this$priority == null ? other$priority != null : !((Object)this$priority).equals(other$priority)) {
            return false;
        }
        String this$priorityGroup = this.getPriorityGroup();
        String other$priorityGroup = other.getPriorityGroup();
        return !(this$priorityGroup == null ? other$priorityGroup != null : !this$priorityGroup.equals(other$priorityGroup));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof QueueDetail;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        long $visibilityTimeout = this.getVisibilityTimeout();
        result = result * 59 + (int)($visibilityTimeout >>> 32 ^ $visibilityTimeout);
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        result = result * 59 + this.getNumRetry();
        QueueType $type = this.getType();
        result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
        String $queueName = this.getQueueName();
        result = result * 59 + ($queueName == null ? 43 : $queueName.hashCode());
        String $deadLetterQueueName = this.getDeadLetterQueueName();
        result = result * 59 + ($deadLetterQueueName == null ? 43 : $deadLetterQueueName.hashCode());
        result = result * 59 + (this.isDeadLetterConsumerEnabled() ? 79 : 97);
        String $processingQueueName = this.getProcessingQueueName();
        result = result * 59 + ($processingQueueName == null ? 43 : $processingQueueName.hashCode());
        String $processingQueueChannelName = this.getProcessingQueueChannelName();
        result = result * 59 + ($processingQueueChannelName == null ? 43 : $processingQueueChannelName.hashCode());
        String $delayedQueueName = this.getDelayedQueueName();
        result = result * 59 + ($delayedQueueName == null ? 43 : $delayedQueueName.hashCode());
        String $delayedQueueChannelName = this.getDelayedQueueChannelName();
        result = result * 59 + ($delayedQueueChannelName == null ? 43 : $delayedQueueChannelName.hashCode());
        result = result * 59 + (this.isActive() ? 79 : 97);
        Concurrency $concurrency = this.getConcurrency();
        result = result * 59 + ($concurrency == null ? 43 : ((Object)$concurrency).hashCode());
        result = result * 59 + (this.isSystemGenerated() ? 79 : 97);
        Map<String, Integer> $priority = this.getPriority();
        result = result * 59 + ($priority == null ? 43 : ((Object)$priority).hashCode());
        String $priorityGroup = this.getPriorityGroup();
        result = result * 59 + ($priorityGroup == null ? 43 : $priorityGroup.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "QueueDetail(visibilityTimeout=" + this.getVisibilityTimeout() + ", name=" + this.getName() + ", numRetry=" + this.getNumRetry() + ", type=" + (Object)((Object)this.getType()) + ", queueName=" + this.getQueueName() + ", deadLetterQueueName=" + this.getDeadLetterQueueName() + ", deadLetterConsumerEnabled=" + this.isDeadLetterConsumerEnabled() + ", processingQueueName=" + this.getProcessingQueueName() + ", processingQueueChannelName=" + this.getProcessingQueueChannelName() + ", delayedQueueName=" + this.getDelayedQueueName() + ", delayedQueueChannelName=" + this.getDelayedQueueChannelName() + ", active=" + this.isActive() + ", concurrency=" + this.getConcurrency() + ", systemGenerated=" + this.isSystemGenerated() + ", priority=" + this.getPriority() + ", priorityGroup=" + this.getPriorityGroup() + ")";
    }

    @Generated
    public static class QueueDetailBuilder {
        @Generated
        private long visibilityTimeout;
        @Generated
        private String name;
        @Generated
        private int numRetry;
        @Generated
        private boolean type$set;
        @Generated
        private QueueType type$value;
        @Generated
        private String queueName;
        @Generated
        private String deadLetterQueueName;
        @Generated
        private boolean deadLetterConsumerEnabled;
        @Generated
        private String processingQueueName;
        @Generated
        private String processingQueueChannelName;
        @Generated
        private String delayedQueueName;
        @Generated
        private String delayedQueueChannelName;
        @Generated
        private boolean active;
        @Generated
        private Concurrency concurrency;
        @Generated
        private boolean systemGenerated;
        @Generated
        private Map<String, Integer> priority;
        @Generated
        private String priorityGroup;

        @Generated
        QueueDetailBuilder() {
        }

        @Generated
        public QueueDetailBuilder visibilityTimeout(long visibilityTimeout) {
            this.visibilityTimeout = visibilityTimeout;
            return this;
        }

        @Generated
        public QueueDetailBuilder name(String name) {
            this.name = name;
            return this;
        }

        @Generated
        public QueueDetailBuilder numRetry(int numRetry) {
            this.numRetry = numRetry;
            return this;
        }

        @Generated
        public QueueDetailBuilder type(QueueType type) {
            this.type$value = type;
            this.type$set = true;
            return this;
        }

        @Generated
        public QueueDetailBuilder queueName(String queueName) {
            this.queueName = queueName;
            return this;
        }

        @Generated
        public QueueDetailBuilder deadLetterQueueName(String deadLetterQueueName) {
            this.deadLetterQueueName = deadLetterQueueName;
            return this;
        }

        @Generated
        public QueueDetailBuilder deadLetterConsumerEnabled(boolean deadLetterConsumerEnabled) {
            this.deadLetterConsumerEnabled = deadLetterConsumerEnabled;
            return this;
        }

        @Generated
        public QueueDetailBuilder processingQueueName(String processingQueueName) {
            this.processingQueueName = processingQueueName;
            return this;
        }

        @Generated
        public QueueDetailBuilder processingQueueChannelName(String processingQueueChannelName) {
            this.processingQueueChannelName = processingQueueChannelName;
            return this;
        }

        @Generated
        public QueueDetailBuilder delayedQueueName(String delayedQueueName) {
            this.delayedQueueName = delayedQueueName;
            return this;
        }

        @Generated
        public QueueDetailBuilder delayedQueueChannelName(String delayedQueueChannelName) {
            this.delayedQueueChannelName = delayedQueueChannelName;
            return this;
        }

        @Generated
        public QueueDetailBuilder active(boolean active) {
            this.active = active;
            return this;
        }

        @Generated
        public QueueDetailBuilder concurrency(Concurrency concurrency) {
            this.concurrency = concurrency;
            return this;
        }

        @Generated
        public QueueDetailBuilder systemGenerated(boolean systemGenerated) {
            this.systemGenerated = systemGenerated;
            return this;
        }

        @Generated
        public QueueDetailBuilder priority(Map<String, Integer> priority) {
            this.priority = priority;
            return this;
        }

        @Generated
        public QueueDetailBuilder priorityGroup(String priorityGroup) {
            this.priorityGroup = priorityGroup;
            return this;
        }

        @Generated
        public QueueDetail build() {
            QueueType type$value = this.type$value;
            if (!this.type$set) {
                type$value = QueueDetail.$default$type();
            }
            return new QueueDetail(this.visibilityTimeout, this.name, this.numRetry, type$value, this.queueName, this.deadLetterQueueName, this.deadLetterConsumerEnabled, this.processingQueueName, this.processingQueueChannelName, this.delayedQueueName, this.delayedQueueChannelName, this.active, this.concurrency, this.systemGenerated, this.priority, this.priorityGroup);
        }

        @Generated
        public String toString() {
            return "QueueDetail.QueueDetailBuilder(visibilityTimeout=" + this.visibilityTimeout + ", name=" + this.name + ", numRetry=" + this.numRetry + ", type$value=" + (Object)((Object)this.type$value) + ", queueName=" + this.queueName + ", deadLetterQueueName=" + this.deadLetterQueueName + ", deadLetterConsumerEnabled=" + this.deadLetterConsumerEnabled + ", processingQueueName=" + this.processingQueueName + ", processingQueueChannelName=" + this.processingQueueChannelName + ", delayedQueueName=" + this.delayedQueueName + ", delayedQueueChannelName=" + this.delayedQueueChannelName + ", active=" + this.active + ", concurrency=" + this.concurrency + ", systemGenerated=" + this.systemGenerated + ", priority=" + this.priority + ", priorityGroup=" + this.priorityGroup + ")";
        }
    }

    public static enum QueueType {
        QUEUE,
        STREAM;

    }
}

