/*
 * Decompiled with CFR 0.152.
 */
package com.github.sonus21.rqueue.dao.impl;

import com.github.sonus21.rqueue.common.RqueueRedisTemplate;
import com.github.sonus21.rqueue.config.RqueueConfig;
import com.github.sonus21.rqueue.dao.RqueueJobDao;
import com.github.sonus21.rqueue.dao.RqueueStringDao;
import com.github.sonus21.rqueue.models.db.RqueueJob;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository
public class RqueueJobDaoImpl
implements RqueueJobDao {
    private final RqueueRedisTemplate<RqueueJob> redisTemplate;
    private final RqueueStringDao rqueueStringDao;
    private final RqueueConfig rqueueConfig;

    @Autowired
    public RqueueJobDaoImpl(RqueueConfig rqueueConfig, RqueueStringDao rqueueStringDao) {
        this.redisTemplate = new RqueueRedisTemplate(rqueueConfig.getConnectionFactory());
        this.rqueueStringDao = rqueueStringDao;
        this.rqueueConfig = rqueueConfig;
    }

    @Override
    public void createJob(RqueueJob rqueueJob, Duration expiry) {
        this.rqueueStringDao.appendToListWithListExpiry(this.rqueueConfig.getJobsKey(rqueueJob.getMessageId()), rqueueJob.getId(), expiry);
        this.save(rqueueJob, expiry);
    }

    @Override
    public void save(RqueueJob rqueueJob, Duration expiry) {
        if (rqueueJob.getCreatedAt() == 0L) {
            rqueueJob.setCreatedAt(System.currentTimeMillis());
            rqueueJob.setUpdatedAt(rqueueJob.getCreatedAt());
        } else if (rqueueJob.getUpdatedAt() != 0L) {
            rqueueJob.setUpdatedAt(System.currentTimeMillis());
        }
        this.redisTemplate.set(rqueueJob.getId(), rqueueJob, expiry);
    }

    @Override
    public RqueueJob findById(String jobId) {
        return this.redisTemplate.get(jobId);
    }

    @Override
    public List<RqueueJob> findJobsByIdIn(Collection<String> jobIds) {
        return this.redisTemplate.mget(jobIds).stream().filter(Objects::nonNull).collect(Collectors.toList());
    }

    @Override
    public List<RqueueJob> finByMessageIdIn(List<String> messageIds) {
        ArrayList<String> jobsKeys = new ArrayList<String>();
        for (String messageId : messageIds) {
            jobsKeys.add(this.rqueueConfig.getJobsKey(messageId));
        }
        Map<String, List<Object>> stringListMap = this.rqueueStringDao.readFromLists(jobsKeys);
        ArrayList<String> jobIds = new ArrayList<String>();
        for (List<Object> objectJobIds : stringListMap.values()) {
            for (Object objectJobId : objectJobIds) {
                jobIds.add((String)objectJobId);
            }
        }
        return this.findJobsByIdIn(jobIds);
    }

    @Override
    public List<RqueueJob> finByMessageId(String messageId) {
        return this.finByMessageIdIn(Collections.singletonList(messageId));
    }
}

