/*
 * Decompiled with CFR 0.152.
 */
package com.github.sonus21.rqueue.core.middleware;

import com.github.sonus21.rqueue.common.RqueueRedisTemplate;
import com.github.sonus21.rqueue.config.RqueueConfig;
import com.github.sonus21.rqueue.core.Job;
import com.github.sonus21.rqueue.core.middleware.LockMiddleware;
import java.time.Duration;
import org.springframework.data.redis.connection.RedisConnectionFactory;

public abstract class RedisLockMiddleware
implements LockMiddleware {
    private final RqueueRedisTemplate<String> template;

    public RedisLockMiddleware(RedisConnectionFactory redisConnectionFactory) {
        this(new RqueueRedisTemplate<String>(redisConnectionFactory));
    }

    public RedisLockMiddleware(RqueueRedisTemplate<String> template) {
        this.template = template;
    }

    protected abstract String getLockIdentifier(Job var1);

    protected Duration getLockDuration(Job job) {
        return job.getQueueDetail().visibilityDuration();
    }

    @Override
    public void releaseLock(Job job, String lockIdentifier) {
        if (lockIdentifier == null) {
            return;
        }
        this.template.delete(lockIdentifier);
    }

    @Override
    public String acquireLock(Job job) {
        String lockIdentifier = this.getLockIdentifier(job);
        Duration lockDuration = this.getLockDuration(job);
        if (Boolean.TRUE.equals(this.template.setIfAbsent(lockIdentifier, RqueueConfig.getBrokerId(), lockDuration))) {
            return lockIdentifier;
        }
        return null;
    }
}

