/*
 * Decompiled with CFR 0.152.
 */
package com.github.sonus21.rqueue.core;

import com.github.sonus21.rqueue.core.RqueueMessage;
import com.github.sonus21.rqueue.exception.UnknownSwitchCase;
import lombok.Generated;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;
import org.springframework.data.redis.core.script.DefaultRedisScript;
import org.springframework.data.redis.core.script.RedisScript;

public class RedisScriptFactory {
    public static <T> RedisScript<T> getScript(ScriptType type) {
        ClassPathResource resource = new ClassPathResource(type.getPath());
        DefaultRedisScript script = new DefaultRedisScript();
        script.setLocation((Resource)resource);
        switch (type) {
            case ENQUEUE_MESSAGE: 
            case MOVE_MESSAGE_TO_ZSET: 
            case MOVE_EXPIRED_MESSAGE: 
            case MOVE_MESSAGE_LIST_TO_LIST: 
            case MOVE_MESSAGE_LIST_TO_ZSET: 
            case MOVE_MESSAGE_ZSET_TO_ZSET: 
            case MOVE_MESSAGE_ZSET_TO_LIST: 
            case SCHEDULE_MESSAGE: {
                script.setResultType(Long.class);
                return script;
            }
            case DELETE_IF_SAME: {
                script.setResultType(Boolean.class);
                return script;
            }
            case DEQUEUE_MESSAGE: {
                script.setResultType(RqueueMessage.class);
                return script;
            }
        }
        throw new UnknownSwitchCase(type.toString());
    }

    @Generated
    public String toString() {
        return "RedisScriptFactory()";
    }

    public static enum ScriptType {
        ENQUEUE_MESSAGE("scripts/enqueue_message.lua"),
        DEQUEUE_MESSAGE("scripts/dequeue_message.lua"),
        MOVE_MESSAGE_TO_ZSET("scripts/move_message_zset.lua"),
        MOVE_MESSAGE_TO_LIST("scripts/move_message_list.lua"),
        MOVE_EXPIRED_MESSAGE("scripts/move_expired_message.lua"),
        MOVE_MESSAGE_LIST_TO_LIST("scripts/move_message_list_to_list.lua"),
        MOVE_MESSAGE_LIST_TO_ZSET("scripts/move_message_list_to_zset.lua"),
        MOVE_MESSAGE_ZSET_TO_ZSET("scripts/move_message_zset_to_zset.lua"),
        MOVE_MESSAGE_ZSET_TO_LIST("scripts/move_message_zset_to_list.lua"),
        SCHEDULE_MESSAGE("scripts/schedule_message.lua"),
        DELETE_IF_SAME("scripts/delete_if_same.lua");

        private final String path;

        private ScriptType(String path) {
            this.path = path;
        }

        public String getPath() {
            return this.path;
        }
    }
}

