/*
 * Decompiled with CFR 0.152.
 */
package com.github.sonus21.rqueue.core;

import com.github.sonus21.rqueue.core.RqueueMessage;
import com.github.sonus21.rqueue.core.context.Context;
import com.github.sonus21.rqueue.listener.QueueDetail;
import com.github.sonus21.rqueue.models.db.Execution;
import com.github.sonus21.rqueue.models.db.MessageMetadata;
import com.github.sonus21.rqueue.models.enums.JobStatus;
import java.io.Serializable;
import java.time.Duration;

public interface Job {
    public String getId();

    public String getMessageId();

    public RqueueMessage getRqueueMessage();

    public void checkIn(Serializable var1);

    public Object getMessage();

    public MessageMetadata getMessageMetadata();

    public JobStatus getStatus();

    public Throwable getException();

    public long getExecutionTime();

    public QueueDetail getQueueDetail();

    public Execution getLatestExecution();

    public Context getContext();

    public void setContext(Context var1);

    public void release(JobStatus var1, Serializable var2, Duration var3);

    public void release(JobStatus var1, Serializable var2);

    public void delete(JobStatus var1, Serializable var2);

    public boolean isDeleted();

    public boolean isReleased();

    public boolean hasMovedToDeadLetterQueue();

    public boolean isDiscarded();

    public int getFailureCount();
}

