/*
 * Decompiled with CFR 0.152.
 */
package com.github.sonus21.rqueue.common;

import com.github.sonus21.rqueue.utils.RedisUtils;
import java.io.Serializable;
import java.time.Duration;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.redis.connection.DataType;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.core.ZSetOperations;

public class RqueueRedisTemplate<V extends Serializable> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RqueueRedisTemplate.class);
    protected RedisTemplate<String, V> redisTemplate;

    public RqueueRedisTemplate(RedisConnectionFactory redisConnectionFactory) {
        this.redisTemplate = RedisUtils.getRedisTemplate(redisConnectionFactory);
        this.redisTemplate.afterPropertiesSet();
    }

    public RedisTemplate<String, V> getRedisTemplate() {
        return this.redisTemplate;
    }

    public Long removeFromZset(String zsetName, V val) {
        return this.redisTemplate.opsForZSet().remove((Object)zsetName, new Object[]{val});
    }

    public Long getListSize(String lName) {
        return this.redisTemplate.opsForList().size((Object)lName);
    }

    public Long getZsetSize(String zsetName) {
        return this.redisTemplate.opsForZSet().size((Object)zsetName);
    }

    public Double getZsetMemberScore(String zsetName, String key) {
        return this.redisTemplate.opsForZSet().score((Object)zsetName, (Object)key);
    }

    public Long rpush(String listName, V val) {
        return this.redisTemplate.opsForList().rightPush((Object)listName, val);
    }

    public Long addToSet(String setName, V ... values) {
        return this.redisTemplate.opsForSet().add((Object)setName, (Object[])values);
    }

    public void set(String key, V val) {
        this.redisTemplate.opsForValue().set((Object)key, val);
    }

    public V get(String key) {
        return (V)((Serializable)this.redisTemplate.opsForValue().get((Object)key));
    }

    public boolean exist(String key) {
        return 1L == this.redisTemplate.countExistingKeys(Collections.singleton(key));
    }

    public int ttl(String key) {
        return this.redisTemplate.getExpire((Object)key, TimeUnit.SECONDS).intValue();
    }

    public List<V> mget(Collection<String> keys) {
        return this.redisTemplate.opsForValue().multiGet(keys);
    }

    public void mset(Map<String, V> map) {
        this.redisTemplate.opsForValue().multiSet(map);
    }

    public void set(String key, V val, Duration duration) {
        this.redisTemplate.opsForValue().set((Object)key, val, duration);
    }

    public Boolean setIfAbsent(String lockKey, V val, Duration duration) {
        return this.redisTemplate.opsForValue().setIfAbsent((Object)lockKey, val, duration);
    }

    public Boolean delete(String key) {
        return this.redisTemplate.delete((Object)key);
    }

    public Object delete(Collection<String> keys) {
        return this.redisTemplate.delete(keys);
    }

    public DataType type(String key) {
        return this.redisTemplate.type((Object)key);
    }

    public List<V> lrange(String key, long start, long end) {
        return this.redisTemplate.opsForList().range((Object)key, start, end);
    }

    public Set<V> zrange(String key, long start, long end) {
        return this.redisTemplate.opsForZSet().range((Object)key, start, end);
    }

    public Set<ZSetOperations.TypedTuple<V>> zrangeWithScore(String key, long start, long end) {
        return this.redisTemplate.opsForZSet().rangeWithScores((Object)key, start, end);
    }

    public Set<V> getMembers(String key) {
        return this.redisTemplate.opsForSet().members((Object)key);
    }

    public void ltrim(String key, Integer start, Integer end) {
        this.redisTemplate.opsForList().trim((Object)key, (long)start.intValue(), (long)end.intValue());
    }

    public Boolean zadd(String key, V val, long score) {
        return this.redisTemplate.opsForZSet().add((Object)key, val, (double)score);
    }

    public void rename(String oldKey, String newKey) {
        this.rename(Collections.singletonList(oldKey), Collections.singletonList(newKey));
    }

    public void rename(List<String> oldKeys, List<String> newKeys) {
        if (oldKeys.size() != newKeys.size()) {
            throw new IllegalArgumentException("Old key and new key space set is different");
        }
        LinkedList<String> srcKeys = new LinkedList<String>();
        LinkedList<String> dstKeys = new LinkedList<String>();
        for (int i = 0; i < oldKeys.size(); ++i) {
            String key = oldKeys.get(i);
            if (!this.exist(key)) continue;
            srcKeys.add(key);
            dstKeys.add(newKeys.get(i));
        }
        log.debug("Pipeline result: {}", RedisUtils.executePipeLine(this.redisTemplate, (connection, keySerializer, valueSerializer) -> {
            for (int i = 0; i < srcKeys.size(); ++i) {
                byte[] src = keySerializer.serialize((Object)((String)srcKeys.get(i)));
                byte[] dst = keySerializer.serialize((Object)((String)dstKeys.get(i)));
                connection.rename(src, dst);
            }
        }));
        if (srcKeys.size() != oldKeys.size()) {
            LinkedList<String> diff = new LinkedList<String>(oldKeys);
            diff.removeAll(srcKeys);
            log.info("Some keys does not exist diff: {}", diff);
        }
    }
}

