/*
 * Decompiled with CFR 0.152.
 */
package com.power.doc.utils;

import com.power.common.util.StringUtil;
import com.power.doc.constants.DocValidatorAnnotationEnum;
import com.power.doc.model.CustomField;
import com.power.doc.model.DocJavaField;
import com.power.doc.utils.DocUtil;
import com.power.doc.utils.JavaClassValidateUtil;
import com.power.doc.utils.ParamUtil;
import com.thoughtworks.qdox.model.JavaAnnotation;
import com.thoughtworks.qdox.model.expression.AnnotationValue;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class JavaFieldUtil {
    public static boolean checkGenerics(List<DocJavaField> fields) {
        for (DocJavaField field : fields) {
            if (field.getJavaField().getType().getFullyQualifiedName().length() != 1) continue;
            return true;
        }
        return false;
    }

    public static void buildCustomField(StringBuilder data0, String typeSimpleName, CustomField customField) {
        Object val = customField.getValue();
        if (null != val) {
            if (DocUtil.javaPrimaryType(typeSimpleName)) {
                data0.append(val).append(",");
            } else {
                data0.append(DocUtil.handleJsonStr(String.valueOf(val))).append(",");
            }
        }
    }

    public static String createMockValue(Map<String, String> paramsComments, String paramName, String typeName, String simpleTypeName) {
        String mockValue = "";
        if (JavaClassValidateUtil.isPrimitive(typeName) && StringUtil.isEmpty((String)(mockValue = Objects.nonNull(mockValue = paramsComments.get(paramName)) && mockValue.contains("|") ? mockValue.substring(mockValue.lastIndexOf("|") + 1) : ""))) {
            mockValue = DocUtil.getValByTypeAndFieldName(simpleTypeName, paramName, Boolean.TRUE);
        }
        return ParamUtil.formatMockValue(mockValue);
    }

    public static String getParamMaxLength(List<JavaAnnotation> annotations) {
        String maxLength = "";
        for (JavaAnnotation annotation : annotations) {
            String simpleAnnotationName = annotation.getType().getValue();
            AnnotationValue annotationValue = null;
            if ("max".equalsIgnoreCase(simpleAnnotationName)) {
                annotationValue = annotation.getProperty("value");
            }
            if ("size".equalsIgnoreCase(simpleAnnotationName)) {
                annotationValue = annotation.getProperty("max");
            }
            if ("length".equalsIgnoreCase(simpleAnnotationName)) {
                annotationValue = annotation.getProperty("max");
            }
            if (Objects.isNull(annotationValue)) continue;
            maxLength = annotationValue.toString();
        }
        return maxLength;
    }

    public static String getJsrComment(List<JavaAnnotation> annotations) {
        StringBuilder sb = new StringBuilder();
        for (JavaAnnotation annotation : annotations) {
            Map values = annotation.getPropertyMap();
            String name = annotation.getType().getValue();
            if (!DocValidatorAnnotationEnum.listValidatorAnnotations().contains(name)) continue;
            for (Map.Entry m : values.entrySet()) {
                String value = DocUtil.resolveAnnotationValue((AnnotationValue)m.getValue());
                if ("regexp".equals(m.getKey())) {
                    sb.append((String)m.getKey()).append(": ").append(StringUtil.removeDoubleQuotes((String)value)).append("; ");
                }
                if ("max".equals(m.getKey())) {
                    sb.append((String)m.getKey()).append(": ").append(StringUtil.removeDoubleQuotes((String)value)).append("; ");
                }
                if ("length".equals(m.getKey())) {
                    sb.append((String)m.getKey()).append(": ").append(StringUtil.removeDoubleQuotes((String)value)).append("; ");
                }
                if (!"size".equals(m.getKey())) continue;
                sb.append((String)m.getKey()).append(": ").append(StringUtil.removeDoubleQuotes((String)value)).append("; ");
            }
        }
        if (sb.length() < 1) {
            return "";
        }
        StringBuilder finalSb = new StringBuilder();
        finalSb.append("\nValidate[").append((CharSequence)sb).append("]");
        return finalSb.toString();
    }
}

