/*
 * Decompiled with CFR 0.152.
 */
package com.power.doc.builder.openapi;

import com.power.common.util.CollectionUtil;
import com.power.common.util.FileUtil;
import com.power.doc.builder.openapi.AbstractOpenApiBuilder;
import com.power.doc.constants.Methods;
import com.power.doc.helper.JavaProjectBuilderHelper;
import com.power.doc.model.ApiConfig;
import com.power.doc.model.ApiDoc;
import com.power.doc.model.ApiMethodDoc;
import com.power.doc.model.ApiParam;
import com.power.doc.model.ApiReqParam;
import com.power.doc.model.TagDoc;
import com.power.doc.model.openapi.OpenApiTag;
import com.power.doc.utils.JsonUtil;
import com.power.doc.utils.OpenApiSchemaUtil;
import com.thoughtworks.qdox.JavaProjectBuilder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public class OpenApiBuilder
extends AbstractOpenApiBuilder {
    private static final OpenApiBuilder INSTANCE = new OpenApiBuilder();

    @Override
    String getModuleName() {
        return "#/components/schemas/";
    }

    public static void buildOpenApi(ApiConfig config) {
        JavaProjectBuilder javaProjectBuilder = JavaProjectBuilderHelper.create();
        OpenApiBuilder.buildOpenApi(config, javaProjectBuilder);
    }

    public static void buildOpenApi(ApiConfig config, JavaProjectBuilder projectBuilder) {
        List<ApiDoc> apiDocList = INSTANCE.getOpenApiDocs(config, projectBuilder);
        INSTANCE.openApiCreate(config, apiDocList);
    }

    @Override
    public void openApiCreate(ApiConfig config, List<ApiDoc> apiDocList) {
        this.setComponentKey(this.getModuleName());
        HashMap<String, Object> json = new HashMap<String, Object>(8);
        json.put("openapi", "3.0.3");
        json.put("info", OpenApiBuilder.buildInfo(config));
        json.put("servers", OpenApiBuilder.buildServers(config));
        HashSet<OpenApiTag> tags = new HashSet<OpenApiTag>();
        json.put("tags", tags);
        json.put("paths", this.buildPaths(config, apiDocList, tags));
        json.put("components", this.buildComponentsSchema(apiDocList));
        String filePath = config.getOutPath();
        filePath = filePath + "/openapi.json";
        String data = JsonUtil.toPrettyJson(json);
        FileUtil.nioWriteFile((String)data, (String)filePath);
    }

    private static Map<String, Object> buildInfo(ApiConfig apiConfig) {
        HashMap<String, Object> infoMap = new HashMap<String, Object>(8);
        infoMap.put("title", apiConfig.getProjectName() == null ? "Project Name is Null." : apiConfig.getProjectName());
        infoMap.put("version", "1.0.0");
        return infoMap;
    }

    private static List<Map<String, Object>> buildServers(ApiConfig config) {
        ArrayList<Map<String, Object>> serverList = new ArrayList<Map<String, Object>>();
        HashMap<String, String> serverMap = new HashMap<String, String>(8);
        serverMap.put("url", config.getServerUrl() == null ? "" : config.getServerUrl());
        serverList.add(serverMap);
        return serverList;
    }

    @Override
    public Map<String, Object> buildPathUrlsRequest(ApiConfig apiConfig, ApiMethodDoc apiMethodDoc, ApiDoc apiDoc) {
        HashMap<String, Object> request = new HashMap<String, Object>(20);
        request.put("summary", apiMethodDoc.getDesc());
        request.put("description", apiMethodDoc.getDetail());
        request.put("tags", apiMethodDoc.getTagRefs().stream().map(TagDoc::getTag).toArray());
        request.put("requestBody", this.buildRequestBody(apiConfig, apiMethodDoc));
        request.put("parameters", this.buildParameters(apiMethodDoc));
        request.put("responses", this.buildResponses(apiConfig, apiMethodDoc));
        request.put("deprecated", apiMethodDoc.isDeprecated());
        List<String> paths = OpenApiSchemaUtil.getPatternResult("[A-Za-z0-9_{}]*", apiMethodDoc.getPath());
        paths.add(apiMethodDoc.getType());
        String operationId = paths.stream().filter(StringUtils::isNotEmpty).collect(Collectors.joining("-"));
        request.put("operationId", operationId);
        return request;
    }

    private Map<String, Object> buildRequestBody(ApiConfig apiConfig, ApiMethodDoc apiMethodDoc) {
        boolean isPost;
        HashMap<String, Object> requestBody = new HashMap<String, Object>(8);
        boolean bl = isPost = apiMethodDoc.getType().equals(Methods.POST.getValue()) || apiMethodDoc.getType().equals(Methods.PUT.getValue()) || apiMethodDoc.getType().equals(Methods.PATCH.getValue());
        if (isPost) {
            requestBody.put("content", this.buildContent(apiConfig, apiMethodDoc, false));
            return requestBody;
        }
        return null;
    }

    @Override
    public Map<String, Object> buildResponsesBody(ApiConfig apiConfig, ApiMethodDoc apiMethodDoc) {
        HashMap<String, Object> responseBody = new HashMap<String, Object>(10);
        responseBody.put("description", "OK");
        responseBody.put("content", this.buildContent(apiConfig, apiMethodDoc, true));
        return responseBody;
    }

    @Override
    List<Map<String, Object>> buildParameters(ApiMethodDoc apiMethodDoc) {
        List<ApiParam> children;
        Map<String, Object> parameters;
        ArrayList<Map<String, Object>> parametersList = new ArrayList<Map<String, Object>>();
        for (ApiParam apiParam : apiMethodDoc.getPathParams()) {
            parameters = this.getStringParams(apiParam, apiParam.isHasItems());
            parameters.put("in", "path");
            children = apiParam.getChildren();
            if (!CollectionUtil.isEmpty(children)) continue;
            parametersList.add(parameters);
        }
        for (ApiParam apiParam : apiMethodDoc.getQueryParams()) {
            if (apiParam.isHasItems()) {
                parameters = this.getStringParams(apiParam, false);
                HashMap<String, Object> arrayMap = new HashMap<String, Object>();
                arrayMap.put("type", "array");
                arrayMap.put("items", this.getStringParams(apiParam, apiParam.isHasItems()));
                parameters.put("schema", arrayMap);
                parametersList.add(parameters);
                continue;
            }
            parameters = this.getStringParams(apiParam, false);
            children = apiParam.getChildren();
            if (!CollectionUtil.isEmpty(children)) continue;
            parametersList.add(parameters);
        }
        if (!CollectionUtil.isEmpty(apiMethodDoc.getRequestHeaders())) {
            for (ApiReqParam header : apiMethodDoc.getRequestHeaders()) {
                parameters = new HashMap<String, Object>(20);
                parameters.put("name", header.getName());
                parameters.put("description", header.getDesc());
                parameters.put("required", header.isRequired());
                parameters.put("example", header.getValue());
                parameters.put("schema", OpenApiBuilder.buildParametersSchema(header));
                parameters.put("in", "header");
                parametersList.add(parameters);
            }
        }
        return parametersList;
    }

    @Override
    Map<String, Object> getStringParams(ApiParam apiParam, boolean hasItems) {
        HashMap<String, Object> parameters = new HashMap<String, Object>(20);
        if (!hasItems) {
            parameters.put("name", apiParam.getField());
            parameters.put("description", apiParam.getDesc());
            parameters.put("required", apiParam.isRequired());
            parameters.put("in", "query");
            parameters.put("schema", this.buildParametersSchema(apiParam));
        } else {
            if ("object".equals(apiParam.getType()) || "array".equals(apiParam.getType()) && apiParam.isHasItems()) {
                parameters.put("type", "object");
                parameters.put("description", "(complex POJO please use @RequestBody)");
            } else {
                String desc = apiParam.getDesc();
                if (desc.contains("file")) {
                    parameters.put("type", "file");
                } else if (desc.contains("string")) {
                    parameters.put("type", "string");
                } else {
                    parameters.put("type", "integer");
                }
            }
            parameters.putAll(this.buildParametersSchema(apiParam));
        }
        return parameters;
    }

    @Override
    public Map<String, Object> buildComponentsSchema(List<ApiDoc> apiDocs) {
        HashMap<String, Object> schemas = new HashMap<String, Object>(4);
        HashMap<String, Map> component = new HashMap<String, Map>();
        component.put("string", STRING_COMPONENT);
        apiDocs.forEach(a -> {
            List<ApiMethodDoc> apiMethodDocs = a.getList();
            apiMethodDocs.forEach(method -> {
                String requestSchema = OpenApiSchemaUtil.getClassNameFromParams(method.getRequestParams(), "_request");
                List<ApiParam> requestParams = method.getRequestParams();
                Map<String, Object> prop = this.buildProperties(requestParams, component, false);
                component.put(requestSchema, prop);
                List<ApiParam> responseParams = method.getResponseParams();
                String schemaName = OpenApiSchemaUtil.getClassNameFromParams(method.getResponseParams(), "_response");
                component.put(schemaName, this.buildProperties(responseParams, component, true));
            });
        });
        component.remove("NO_BODY_PARAM");
        schemas.put("schemas", component);
        return schemas;
    }
}

