/*
 * Decompiled with CFR 0.152.
 */
package com.power.doc.template;

import com.power.common.util.StringUtil;
import com.power.common.util.UrlUtil;
import com.power.doc.builder.ProjectDocConfigBuilder;
import com.power.doc.helper.ParamsBuildHelper;
import com.power.doc.model.ApiMethodDoc;
import com.power.doc.model.ApiParam;
import com.power.doc.model.ApiReturn;
import com.power.doc.model.DocJavaMethod;
import com.power.doc.model.DocJavaParameter;
import com.power.doc.model.annotation.FrameworkAnnotations;
import com.power.doc.utils.ApiParamTreeUtil;
import com.power.doc.utils.DocClassUtil;
import com.power.doc.utils.DocUtil;
import com.power.doc.utils.JavaClassValidateUtil;
import com.power.doc.utils.OpenApiSchemaUtil;
import com.thoughtworks.qdox.model.DocletTag;
import com.thoughtworks.qdox.model.JavaAnnotation;
import com.thoughtworks.qdox.model.JavaMethod;
import com.thoughtworks.qdox.model.JavaParameter;
import com.thoughtworks.qdox.model.JavaType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public interface IBaseDocBuildTemplate {
    default public String paramCommentResolve(String comment) {
        if (StringUtil.isEmpty((String)comment)) {
            comment = "No comments found.";
        } else if (comment.contains("|")) {
            comment = comment.substring(0, comment.indexOf("|"));
        }
        return comment;
    }

    default public List<ApiParam> buildReturnApiParams(DocJavaMethod docJavaMethod, ProjectDocConfigBuilder projectBuilder) {
        String typeName;
        String responseBodyAdvice;
        JavaMethod method = docJavaMethod.getJavaMethod();
        if (method.getReturns().isVoid() && Objects.isNull(projectBuilder.getApiConfig().getResponseBodyAdvice())) {
            return new ArrayList<ApiParam>(0);
        }
        DocletTag downloadTag = method.getTagByName("download");
        if (Objects.nonNull(downloadTag)) {
            return new ArrayList<ApiParam>(0);
        }
        String returnTypeGenericCanonicalName = method.getReturnType().getGenericCanonicalName();
        if (Objects.nonNull(projectBuilder.getApiConfig().getResponseBodyAdvice()) && Objects.isNull(method.getTagByName("ignoreResponseBodyAdvice")) && !returnTypeGenericCanonicalName.startsWith(responseBodyAdvice = projectBuilder.getApiConfig().getResponseBodyAdvice().getClassName())) {
            returnTypeGenericCanonicalName = new StringBuffer().append(responseBodyAdvice).append("<").append(returnTypeGenericCanonicalName).append(">").toString();
        }
        Map<String, JavaType> actualTypesMap = docJavaMethod.getActualTypesMap();
        ApiReturn apiReturn = DocClassUtil.processReturnType(returnTypeGenericCanonicalName);
        String returnType = apiReturn.getGenericCanonicalName();
        if (Objects.nonNull(actualTypesMap)) {
            for (Map.Entry<String, JavaType> entry : actualTypesMap.entrySet()) {
                returnType = returnType.replace(entry.getKey(), entry.getValue().getCanonicalName());
            }
        }
        if (this.ignoreReturnObject(typeName = apiReturn.getSimpleName(), projectBuilder.getApiConfig().getIgnoreRequestParams())) {
            return new ArrayList<ApiParam>(0);
        }
        if (JavaClassValidateUtil.isPrimitive(typeName)) {
            docJavaMethod.setReturnSchema(OpenApiSchemaUtil.primaryTypeSchema(typeName));
            return new ArrayList<ApiParam>(0);
        }
        if (JavaClassValidateUtil.isCollection(typeName)) {
            if (returnType.contains("<")) {
                String gicName = returnType.substring(returnType.indexOf("<") + 1, returnType.lastIndexOf(">"));
                if (JavaClassValidateUtil.isPrimitive(gicName)) {
                    docJavaMethod.setReturnSchema(OpenApiSchemaUtil.arrayTypeSchema(gicName));
                    return new ArrayList<ApiParam>(0);
                }
                return ParamsBuildHelper.buildParams(gicName, "", 0, null, Boolean.TRUE, new HashMap<String, String>(), projectBuilder, null, 0, Boolean.FALSE, null);
            }
            return new ArrayList<ApiParam>(0);
        }
        if (JavaClassValidateUtil.isMap(typeName)) {
            String[] keyValue = DocClassUtil.getMapKeyValueType(returnType);
            if (keyValue.length == 0) {
                return new ArrayList<ApiParam>(0);
            }
            return ParamsBuildHelper.buildParams(returnType, "", 0, null, Boolean.TRUE, new HashMap<String, String>(), projectBuilder, null, 0, Boolean.FALSE, null);
        }
        if (StringUtil.isNotEmpty((String)returnType)) {
            return ParamsBuildHelper.buildParams(returnType, "", 0, null, Boolean.TRUE, new HashMap<String, String>(), projectBuilder, null, 0, Boolean.FALSE, null);
        }
        return new ArrayList<ApiParam>(0);
    }

    default public void convertParamsDataToTree(ApiMethodDoc apiMethodDoc) {
        apiMethodDoc.setPathParams(ApiParamTreeUtil.apiParamToTree(apiMethodDoc.getPathParams()));
        apiMethodDoc.setQueryParams(ApiParamTreeUtil.apiParamToTree(apiMethodDoc.getQueryParams()));
        apiMethodDoc.setRequestParams(ApiParamTreeUtil.apiParamToTree(apiMethodDoc.getRequestParams()));
    }

    default public String formatRequestUrl(Map<String, String> pathParamsMap, Map<String, String> queryParamsMap, String serverUrl, String path) {
        path = DocUtil.formatAndRemove(path, pathParamsMap);
        String url = UrlUtil.urlJoin((String)path, queryParamsMap);
        url = StringUtil.removeQuotes((String)url);
        url = serverUrl + "/" + url;
        url = UrlUtil.simplifyUrl((String)url);
        return url;
    }

    default public List<DocJavaParameter> getJavaParameterList(ProjectDocConfigBuilder builder, DocJavaMethod docJavaMethod, FrameworkAnnotations frameworkAnnotations) {
        JavaMethod javaMethod = docJavaMethod.getJavaMethod();
        Map<String, String> replacementMap = builder.getReplaceClassMap();
        Map<String, String> paramTagMap = docJavaMethod.getParamTagMap();
        List parameterList = javaMethod.getParameters();
        if (parameterList.isEmpty()) {
            return new ArrayList<DocJavaParameter>(0);
        }
        Set<String> ignoreSets = this.ignoreParamsSets(javaMethod);
        ArrayList<DocJavaParameter> apiJavaParameterList = new ArrayList<DocJavaParameter>(parameterList.size());
        Map<String, JavaType> actualTypesMap = docJavaMethod.getActualTypesMap();
        for (JavaParameter parameter : parameterList) {
            String paramName = parameter.getName();
            if (ignoreSets.contains(paramName)) continue;
            DocJavaParameter apiJavaParameter = new DocJavaParameter();
            apiJavaParameter.setJavaParameter(parameter);
            JavaType javaType = parameter.getType();
            if (Objects.nonNull(actualTypesMap) && Objects.nonNull(actualTypesMap.get(javaType.getCanonicalName()))) {
                javaType = actualTypesMap.get(javaType.getCanonicalName());
            }
            apiJavaParameter.setTypeValue(javaType.getValue());
            String genericCanonicalName = javaType.getGenericCanonicalName();
            String fullTypeName = javaType.getFullyQualifiedName();
            String commentClass = paramTagMap.get(paramName);
            if (Objects.nonNull(commentClass) && commentClass.contains("ignore")) continue;
            String rewriteClassName = this.getRewriteClassName(replacementMap, fullTypeName, commentClass);
            if (JavaClassValidateUtil.isClassName(rewriteClassName)) {
                genericCanonicalName = rewriteClassName;
                fullTypeName = DocClassUtil.getSimpleName(rewriteClassName);
            }
            if (JavaClassValidateUtil.isMvcIgnoreParams(genericCanonicalName, builder.getApiConfig().getIgnoreRequestParams())) continue;
            fullTypeName = DocClassUtil.rewriteRequestParam(fullTypeName);
            genericCanonicalName = DocClassUtil.rewriteRequestParam(genericCanonicalName);
            List annotations = parameter.getAnnotations();
            apiJavaParameter.setAnnotations(annotations);
            for (JavaAnnotation annotation : annotations) {
                String requestBodyAdvice;
                String annotationName = annotation.getType().getValue();
                if (!Objects.nonNull(frameworkAnnotations) || !frameworkAnnotations.getRequestBodyAnnotation().getAnnotationName().equals(annotationName) || !Objects.nonNull(builder.getApiConfig().getRequestBodyAdvice()) || !Objects.isNull(javaMethod.getTagByName("ignoreRequestBodyAdvice"))) continue;
                fullTypeName = requestBodyAdvice = builder.getApiConfig().getRequestBodyAdvice().getClassName();
                genericCanonicalName = requestBodyAdvice + "<" + genericCanonicalName + ">";
            }
            if ((JavaClassValidateUtil.isCollection(fullTypeName) || JavaClassValidateUtil.isArray(fullTypeName)) && JavaClassValidateUtil.isCollection(genericCanonicalName)) {
                genericCanonicalName = genericCanonicalName + "<T>";
            }
            apiJavaParameter.setGenericCanonicalName(genericCanonicalName);
            apiJavaParameter.setFullyQualifiedName(fullTypeName);
            apiJavaParameterList.add(apiJavaParameter);
        }
        return apiJavaParameterList;
    }

    default public String getRewriteClassName(Map<String, String> replacementMap, String fullTypeName, String commentClass) {
        if (Objects.nonNull(commentClass) && !"No comments found.".equals(commentClass)) {
            String[] comments = commentClass.split("\\|");
            if (comments.length < 1) {
                return replacementMap.get(fullTypeName);
            }
            String rewriteClassName = comments[comments.length - 1];
            if (JavaClassValidateUtil.isClassName(rewriteClassName)) {
                return rewriteClassName;
            }
        }
        return replacementMap.get(fullTypeName);
    }

    default public Set<String> ignoreParamsSets(JavaMethod method) {
        HashSet<String> ignoreSets = new HashSet<String>();
        DocletTag ignoreParam = method.getTagByName("ignoreParams");
        if (Objects.nonNull(ignoreParam)) {
            String[] igParams = ignoreParam.getValue().split(" ");
            Collections.addAll(ignoreSets, igParams);
        }
        return ignoreSets;
    }

    public boolean ignoreReturnObject(String var1, List<String> var2);
}

