/*
 * Decompiled with CFR 0.152.
 */
package com.power.doc.handler;

import com.power.common.util.StringUtil;
import com.power.common.util.UrlUtil;
import com.power.doc.builder.ProjectDocConfigBuilder;
import com.power.doc.constants.MediaType;
import com.power.doc.model.request.JaxrsPathMapping;
import com.power.doc.utils.DocUrlUtil;
import com.power.doc.utils.DocUtil;
import com.thoughtworks.qdox.model.JavaAnnotation;
import com.thoughtworks.qdox.model.JavaMethod;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class JaxrsPathHandler {
    private static final Set<String> ANNOTATION_NAMES = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("jakarta.ws.rs.DELETE", "jakarta.ws.rs.PUT", "jakarta.ws.rs.GET", "jakarta.ws.rs.POST", "jakarta.ws.rs.PATCH", "jakarta.ws.rs.HEAD", "javax.ws.rs.DELETE", "javax.ws.rs.PUT", "javax.ws.rs.GET", "javax.ws.rs.POST", "javax.ws.rs.PATCH", "javax.ws.rs.HEAD")));
    Map<String, String> constantsMap;

    public JaxrsPathMapping handle(ProjectDocConfigBuilder projectBuilder, String baseUrl, JavaMethod method, String mediaType) {
        JaxrsPathMapping jaxrsPathMapping;
        List annotations = method.getAnnotations();
        this.constantsMap = projectBuilder.getConstantsMap();
        String methodType = null;
        String shortUrl = "";
        String serverUrl = projectBuilder.getServerUrl();
        String contextPath = projectBuilder.getApiConfig().getPathPrefix();
        boolean deprecated = false;
        for (JavaAnnotation annotation : annotations) {
            Object value;
            String annotationName = annotation.getType().getFullyQualifiedName();
            if ((annotationName.equals("Consumes") || annotationName.equals("javax.ws.rs.Consumes")) && Objects.nonNull(value = annotation.getNamedParameter("value"))) {
                mediaType = MediaType.valueOf(value.toString());
            }
            if ("java.lang.Deprecated".equals(annotationName)) {
                deprecated = true;
            }
            if ("jakarta.ws.rs.Path".equals(annotationName) || "jakarta.ws.rs.PathParam".equals(annotationName) || "org.jboss.resteasy.reactive.RestPath".equals(annotationName) || "javax.ws.rs.Path".equals(annotationName) || "javax.ws.rs.PathParam".equals(annotationName)) {
                shortUrl = DocUtil.handleMappingValue(annotation);
            }
            if (!ANNOTATION_NAMES.stream().anyMatch(it -> it.contains(annotationName))) continue;
            methodType = annotation.getType().getName();
        }
        if (Objects.nonNull(method.getTagByName("deprecated"))) {
            deprecated = true;
        }
        if ((jaxrsPathMapping = this.getJaxbPathMapping(projectBuilder, baseUrl, method, shortUrl, serverUrl, contextPath)) != null) {
            return jaxrsPathMapping.setDeprecated(deprecated).setMethodType(methodType).setMediaType(mediaType);
        }
        return null;
    }

    private JaxrsPathMapping getJaxbPathMapping(ProjectDocConfigBuilder projectBuilder, String baseUrl, JavaMethod method, String shortUrl, String serverUrl, String contextPath) {
        if (Objects.nonNull(shortUrl)) {
            if (Objects.nonNull(method.getTagByName("ignore"))) {
                return null;
            }
            shortUrl = StringUtil.removeQuotes((String)shortUrl);
            List<String> urls = DocUtil.split(shortUrl);
            String url = String.join((CharSequence)"/", serverUrl, contextPath, baseUrl, shortUrl);
            shortUrl = String.join((CharSequence)"/", "/", contextPath, baseUrl, shortUrl);
            if (urls.size() > 1) {
                url = DocUrlUtil.getMvcUrls(serverUrl, contextPath + "/" + baseUrl, urls);
                shortUrl = DocUrlUtil.getMvcUrls("", contextPath + "/" + baseUrl, urls);
            }
            for (Map.Entry<String, String> entry : this.constantsMap.entrySet()) {
                String key = entry.getKey();
                String value = entry.getValue();
                if (url.contains(key)) {
                    url = url.replace(key, value).replace("+", "");
                }
                if (!shortUrl.contains(key)) continue;
                shortUrl = shortUrl.replace(key, value).replace("+", "");
            }
            String urlSuffix = projectBuilder.getApiConfig().getUrlSuffix();
            url = UrlUtil.simplifyUrl((String)url);
            shortUrl = UrlUtil.simplifyUrl((String)shortUrl);
            if (StringUtil.isNotEmpty((String)urlSuffix)) {
                url = url + urlSuffix;
                shortUrl = shortUrl + urlSuffix;
            }
            return JaxrsPathMapping.builder().setUrl(StringUtil.trim((String)url)).setShortUrl(StringUtil.trim((String)shortUrl));
        }
        return null;
    }
}

