/*
 * Decompiled with CFR 0.152.
 */
package com.power.doc.builder;

import com.power.common.util.CollectionUtil;
import com.power.common.util.JsonFormatUtil;
import com.power.common.util.StringUtil;
import com.power.common.util.UrlUtil;
import com.power.doc.model.ApiConfig;
import com.power.doc.model.ApiDoc;
import com.power.doc.model.ApiMethodDoc;
import com.power.doc.model.ApiParam;
import com.power.doc.model.ApiReqHeader;
import com.power.doc.model.ApiReturn;
import com.power.doc.model.CustomRespField;
import com.power.doc.model.SourceCodePath;
import com.power.doc.utils.DocClassUtil;
import com.power.doc.utils.DocUtil;
import com.thoughtworks.qdox.JavaProjectBuilder;
import com.thoughtworks.qdox.model.DocletTag;
import com.thoughtworks.qdox.model.JavaAnnotation;
import com.thoughtworks.qdox.model.JavaClass;
import com.thoughtworks.qdox.model.JavaField;
import com.thoughtworks.qdox.model.JavaMethod;
import com.thoughtworks.qdox.model.JavaParameter;
import com.thoughtworks.qdox.model.JavaType;
import com.thoughtworks.qdox.model.expression.AnnotationValue;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.codec.digest.DigestUtils;

public class SourceBuilder {
    private static final String IGNORE_TAG = "ignore";
    private static final String GET_MAPPING = "GetMapping";
    private static final String POST_MAPPING = "PostMapping";
    private static final String PUT_MAPPING = "PutMapping";
    private static final String DELETE_MAPPING = "DeleteMapping";
    private static final String REQUEST_MAPPING = "RequestMapping";
    private static final String REQUEST_BODY = "RequestBody";
    private static final String REQUEST_HERDER = "RequestHeader";
    private static final String REQUEST_PARAM = "RequestParam";
    private static final String JSON_CONTENT_TYPE = "application/json; charset=utf-8";
    private static final String MAP_CLASS = "java.util.Map";
    private static final String NO_COMMENTS_FOUND = "No comments found.";
    private static final String VALID = "Valid";
    private static final String METHOD_DESCRIPTION = "apiNote";
    private Map<String, JavaClass> javaFilesMap = new HashMap<String, JavaClass>();
    private Map<String, CustomRespField> fieldMap = new HashMap<String, CustomRespField>();
    private JavaProjectBuilder builder;
    private Collection<JavaClass> javaClasses;
    private boolean isStrict;
    private String packageMatch;
    private List<ApiReqHeader> headers;
    private String appUrl;
    private boolean isUseMD5;
    private boolean isAdoc;

    public SourceBuilder(boolean isStrict) {
        this.loadJavaFiles(null);
        this.isStrict = isStrict;
    }

    public SourceBuilder(ApiConfig config) {
        if (null == config) {
            throw new NullPointerException("ApiConfig can't be null.");
        }
        this.appUrl = StringUtil.isEmpty((String)config.getServerUrl()) ? "http://{server}" : config.getServerUrl();
        this.isUseMD5 = config.isMd5EncryptedHtmlName();
        this.packageMatch = config.getPackageFilters();
        this.isStrict = config.isStrict();
        this.isAdoc = config.isAdoc();
        this.loadJavaFiles(config.getSourceCodePaths());
        this.headers = config.getRequestHeaders();
        if (CollectionUtil.isNotEmpty(config.getCustomResponseFields())) {
            for (CustomRespField field : config.getCustomResponseFields()) {
                this.fieldMap.put(field.getName(), field);
            }
        }
    }

    public List<ApiDoc> getControllerApiData() {
        ArrayList<ApiDoc> apiDocList = new ArrayList<ApiDoc>();
        int order = 0;
        for (JavaClass cls : this.javaClasses) {
            if (!this.checkController(cls)) continue;
            if (StringUtil.isNotEmpty((String)this.packageMatch)) {
                if (!DocUtil.isMatch(this.packageMatch, cls.getCanonicalName())) continue;
                this.handleApiDoc(cls, apiDocList, ++order);
                continue;
            }
            this.handleApiDoc(cls, apiDocList, ++order);
        }
        return apiDocList;
    }

    public ApiDoc getSingleControllerApiData(String controller) {
        if (!this.javaFilesMap.containsKey(controller)) {
            throw new RuntimeException("Unable to find " + controller + " in your project");
        }
        JavaClass cls = this.builder.getClassByName(controller);
        if (this.checkController(cls)) {
            String controllerName = cls.getName();
            List<ApiMethodDoc> apiMethodDocs = this.buildControllerMethod(cls);
            ApiDoc apiDoc = new ApiDoc();
            apiDoc.setList(apiMethodDocs);
            apiDoc.setName(controllerName);
            return apiDoc;
        }
        throw new RuntimeException(controller + " is not a Controller in your project");
    }

    private List<ApiMethodDoc> buildControllerMethod(JavaClass cls) {
        String clazName = cls.getCanonicalName();
        List classAnnotations = cls.getAnnotations();
        String baseUrl = "";
        for (JavaAnnotation annotation : classAnnotations) {
            String annotationName = annotation.getType().getName();
            if (!REQUEST_MAPPING.equals(annotationName) && !"org.springframework.web.bind.annotation.RequestMapping".equals(annotationName)) continue;
            baseUrl = annotation.getNamedParameter("value").toString();
            baseUrl = baseUrl.replaceAll("\"", "");
        }
        List methods = cls.getMethods();
        ArrayList<ApiMethodDoc> methodDocList = new ArrayList<ApiMethodDoc>(methods.size());
        int methodOrder = 0;
        for (JavaMethod method : methods) {
            ArrayList<ApiReqHeader> apiReqHeaders = new ArrayList<ApiReqHeader>();
            if (method.getModifiers().contains("private")) continue;
            if (StringUtil.isEmpty((String)method.getComment()) && this.isStrict) {
                throw new RuntimeException("Unable to find comment for method " + method.getName() + " in " + cls.getCanonicalName());
            }
            ApiMethodDoc apiMethodDoc = new ApiMethodDoc();
            apiMethodDoc.setOrder(++methodOrder);
            apiMethodDoc.setDesc(method.getComment());
            apiMethodDoc.setName(method.getName());
            String methodUid = clazName + method.getName();
            this.handleMethodUid(apiMethodDoc, methodUid);
            String apiNoteValue = DocUtil.getNormalTagComments(method, METHOD_DESCRIPTION, cls.getName());
            if (StringUtil.isEmpty((String)apiNoteValue)) {
                apiNoteValue = method.getComment();
            }
            apiMethodDoc.setDetail(apiNoteValue);
            List annotations = method.getAnnotations();
            String url = null;
            String methodType = null;
            boolean isPostMethod = false;
            int methodCounter = 0;
            for (JavaAnnotation annotation : annotations) {
                String annotationName = annotation.getType().getName();
                if (REQUEST_MAPPING.equals(annotationName) || "org.springframework.web.bind.annotation.RequestMapping".equals(annotationName)) {
                    url = DocUtil.handleMappingValue(annotation);
                    Object nameParam = annotation.getNamedParameter("method");
                    if (null != nameParam) {
                        methodType = nameParam.toString();
                        if ("POST".equals(methodType = DocUtil.handleHttpMethod(methodType)) || "PUT".equals(methodType)) {
                            isPostMethod = true;
                        }
                    } else {
                        methodType = "GET";
                    }
                    ++methodCounter;
                    continue;
                }
                if (GET_MAPPING.equals(annotationName) || "org.springframework.web.bind.annotation.GetMapping".equals(annotationName)) {
                    url = DocUtil.handleMappingValue(annotation);
                    methodType = "GET";
                    ++methodCounter;
                    continue;
                }
                if (POST_MAPPING.equals(annotationName) || "org.springframework.web.bind.annotation.PostMapping".equals(annotationName)) {
                    url = DocUtil.handleMappingValue(annotation);
                    methodType = "POST";
                    ++methodCounter;
                    isPostMethod = true;
                    continue;
                }
                if (PUT_MAPPING.equals(annotationName) || "org.springframework.web.bind.annotation.PutMapping".equals(annotationName)) {
                    url = DocUtil.handleMappingValue(annotation);
                    methodType = "PUT";
                    ++methodCounter;
                    continue;
                }
                if (!DELETE_MAPPING.equals(annotationName) && !"org.springframework.web.bind.annotation.DeleteMapping".equals(annotationName)) continue;
                url = DocUtil.handleMappingValue(annotation);
                methodType = "DELETE";
                ++methodCounter;
            }
            block3: for (JavaParameter javaParameter : method.getParameters()) {
                List javaAnnotations = javaParameter.getAnnotations();
                String className = method.getDeclaringClass().getCanonicalName();
                Map<String, String> paramMap = DocUtil.getParamsComments(method, "param", className);
                String paramName = javaParameter.getName();
                for (JavaAnnotation annotation : javaAnnotations) {
                    String annotationName = annotation.getType().getName();
                    if (!REQUEST_HERDER.equals(annotationName)) continue;
                    ApiReqHeader apiReqHeader = new ApiReqHeader();
                    Map requestHeaderMap = annotation.getNamedParameterMap();
                    if (requestHeaderMap.get("value") != null) {
                        apiReqHeader.setName(StringUtil.removeQuotes((String)((String)requestHeaderMap.get("value"))));
                    } else {
                        apiReqHeader.setName(paramName);
                    }
                    StringBuilder desc = new StringBuilder();
                    String comments = paramMap.get(paramName);
                    desc.append(comments);
                    if (requestHeaderMap.get("defaultValue") != null) {
                        desc.append("(defaultValue: ").append(StringUtil.removeQuotes((String)((String)requestHeaderMap.get("defaultValue")))).append(")");
                    }
                    apiReqHeader.setDesc(desc.toString());
                    if (requestHeaderMap.get("required") != null) {
                        apiReqHeader.setRequired(!"false".equals(requestHeaderMap.get("required")));
                    } else {
                        apiReqHeader.setRequired(true);
                    }
                    String typeName = javaParameter.getType().getValue().toLowerCase();
                    apiReqHeader.setType(DocClassUtil.processTypeNameForParams(typeName));
                    apiReqHeaders.add(apiReqHeader);
                    continue block3;
                }
            }
            apiMethodDoc.setRequestHeaders(apiReqHeaders);
            if (methodCounter <= 0 || null != method.getTagByName(IGNORE_TAG)) continue;
            url = url.replaceAll("\"", "").trim();
            apiMethodDoc.setType(methodType);
            url = this.appUrl + "/" + baseUrl + "/" + url;
            apiMethodDoc.setUrl(UrlUtil.simplifyUrl((String)url));
            List<ApiParam> requestParams = this.requestParams(method, "param", cls.getCanonicalName());
            apiMethodDoc.setRequestParams(requestParams);
            String requestJson = this.buildReqJson(method, apiMethodDoc, isPostMethod);
            apiMethodDoc.setRequestUsage(JsonFormatUtil.formatJson((String)requestJson));
            apiMethodDoc.setResponseUsage(this.buildReturnJson(method, this.fieldMap));
            List<ApiParam> responseParams = this.buildReturnApiParams(method, cls.getGenericFullyQualifiedName());
            apiMethodDoc.setResponseParams(responseParams);
            apiMethodDoc.setHeaders(this.createHeaders(this.headers, this.isAdoc));
            List<ApiReqHeader> allApiReqHeaders = this.headers != null ? Stream.of(this.headers, apiReqHeaders).flatMap(Collection::stream).collect(Collectors.toList()) : apiReqHeaders;
            apiMethodDoc.setRequestHeaders(allApiReqHeaders);
            methodDocList.add(apiMethodDoc);
        }
        return methodDocList;
    }

    private void loadJavaFiles(List<SourceCodePath> paths) {
        JavaProjectBuilder builder = new JavaProjectBuilder();
        if (CollectionUtil.isEmpty(paths)) {
            builder.addSourceTree(new File("src/main/java"));
        } else {
            if (!paths.contains("src/main/java")) {
                builder.addSourceTree(new File("src/main/java"));
            }
            for (SourceCodePath path : paths) {
                String strPath;
                if (null == path || !StringUtil.isNotEmpty((String)(strPath = path.getPath()))) continue;
                strPath = strPath.replace("\\", "/");
                builder.addSourceTree(new File(strPath));
            }
        }
        this.builder = builder;
        this.javaClasses = builder.getClasses();
        for (JavaClass cls : this.javaClasses) {
            this.javaFilesMap.put(cls.getFullyQualifiedName(), cls);
        }
    }

    private String createHeaders(List<ApiReqHeader> headers, boolean isAdoc) {
        StringBuilder builder = new StringBuilder();
        if (CollectionUtil.isEmpty(headers)) {
            headers = new ArrayList<ApiReqHeader>(0);
        }
        for (ApiReqHeader header : headers) {
            if (isAdoc) {
                builder.append("|");
            }
            builder.append(header.getName()).append("|").append(header.getType()).append("|").append(header.getDesc()).append("|").append(header.isRequired()).append("|").append(header.getSince()).append("\n");
        }
        return builder.toString();
    }

    private List<ApiParam> buildReturnApiParams(JavaMethod method, String controllerName) {
        ApiReturn apiReturn = DocClassUtil.processReturnType(method.getReturnType().getGenericCanonicalName());
        String returnType = apiReturn.getGenericCanonicalName();
        String typeName = apiReturn.getSimpleName();
        if (DocClassUtil.isMvcIgnoreParams(typeName)) {
            if ("org.springframework.web.servlet.ModelAndView".equals(typeName)) {
                return null;
            }
            throw new RuntimeException("smart-doc can't support " + typeName + " as method return in " + controllerName);
        }
        if (DocClassUtil.isPrimitive(typeName)) {
            return this.primitiveReturnRespComment(DocClassUtil.processTypeNameForParams(typeName));
        }
        if (DocClassUtil.isCollection(typeName)) {
            if (returnType.contains("<")) {
                String gicName = returnType.substring(returnType.indexOf("<") + 1, returnType.lastIndexOf(">"));
                if (DocClassUtil.isPrimitive(gicName)) {
                    return this.primitiveReturnRespComment("array of " + DocClassUtil.processTypeNameForParams(gicName));
                }
                return this.buildParams(gicName, "", 0, null, this.fieldMap, true, false);
            }
            return null;
        }
        if (DocClassUtil.isMap(typeName)) {
            String[] keyValue = DocClassUtil.getMapKeyValueType(returnType);
            if (keyValue.length == 0) {
                return null;
            }
            if (DocClassUtil.isPrimitive(keyValue[1])) {
                return this.primitiveReturnRespComment("key value");
            }
            return this.buildParams(keyValue[1], "", 0, null, this.fieldMap, true, false);
        }
        if (StringUtil.isNotEmpty((String)returnType)) {
            return this.buildParams(returnType, "", 0, null, this.fieldMap, true, false);
        }
        return null;
    }

    private List<ApiParam> buildParams(String className, String pre, int i, String isRequired, Map<String, CustomRespField> responseFieldMap, boolean isResp, boolean isSkip) {
        if (StringUtil.isEmpty((String)className)) {
            throw new RuntimeException("Class name can't be null or empty.");
        }
        ArrayList<ApiParam> paramList = new ArrayList<ApiParam>();
        if (i > 2 && isSkip) {
            return paramList;
        }
        String simpleName = DocClassUtil.getSimpleName(className);
        String[] globGicName = DocClassUtil.getSimpleGicName(className);
        JavaClass cls = this.getJavaClass(simpleName);
        List<JavaField> fields = this.getFields(cls, 0);
        int n = 0;
        if (DocClassUtil.isPrimitive(simpleName)) {
            paramList.addAll(this.primitiveReturnRespComment(DocClassUtil.processTypeNameForParams(simpleName)));
        } else if (DocClassUtil.isCollection(simpleName) || DocClassUtil.isArray(simpleName)) {
            if (!DocClassUtil.isCollection(globGicName[0])) {
                String gicName = globGicName[0];
                if (DocClassUtil.isArray(gicName)) {
                    gicName = gicName.substring(0, gicName.indexOf("["));
                }
                paramList.addAll(this.buildParams(gicName, pre, i + 1, isRequired, responseFieldMap, isResp, false));
            }
        } else if (DocClassUtil.isMap(simpleName)) {
            if (globGicName.length == 2) {
                paramList.addAll(this.buildParams(globGicName[1], pre, i + 1, isRequired, responseFieldMap, isResp, false));
            }
        } else if ("java.lang.Object".equals(className)) {
            ApiParam param = ApiParam.of().setField(pre + "any object").setType("object");
            if (StringUtil.isEmpty((String)isRequired)) {
                param.setDesc("any object.").setVersion("-");
            } else {
                param.setDesc("any object.").setRequired(false).setVersion("-");
            }
            paramList.add(param);
        } else {
            block0: for (JavaField field : fields) {
                String gName;
                String processedType;
                ApiParam param;
                CustomRespField customResponseField;
                String comment;
                String fieldName = field.getName();
                if ("serialVersionUID".equals(fieldName)) continue;
                String typeSimpleName = field.getType().getSimpleName();
                String subTypeName = field.getType().getFullyQualifiedName();
                String fieldGicName = field.getType().getGenericCanonicalName();
                List javaAnnotations = field.getAnnotations();
                List paramTags = field.getTags();
                String since = "-";
                if (!isResp) {
                    for (DocletTag docletTag : paramTags) {
                        if (DocClassUtil.isIgnoreTag(docletTag.getName())) continue block0;
                        if (!"since".equals(docletTag.getName())) continue;
                        since = docletTag.getValue();
                    }
                } else {
                    for (DocletTag docletTag : paramTags) {
                        if (!"since".equals(docletTag.getName())) continue;
                        since = docletTag.getValue();
                    }
                }
                boolean strRequired = false;
                int annotationCounter = 0;
                for (JavaAnnotation annotation : javaAnnotations) {
                    String annotationName = annotation.getType().getSimpleName();
                    if ("JsonIgnore".equals(annotationName) && isResp) continue block0;
                    if ("JSONField".equals(annotationName) && isResp) {
                        if (null != annotation.getProperty("serialize")) {
                            if (!"false".equals(annotation.getProperty("serialize").toString())) continue;
                            continue block0;
                        }
                        if (null == annotation.getProperty("name")) continue;
                        fieldName = annotation.getProperty("name").toString().replace("\"", "");
                        continue;
                    }
                    if ("JsonProperty".equals(annotationName) && isResp) {
                        if (null == annotation.getProperty("value")) continue;
                        fieldName = annotation.getProperty("value").toString().replace("\"", "");
                        continue;
                    }
                    if (!DocClassUtil.isJSR303Required(annotationName)) continue;
                    strRequired = true;
                    ++annotationCounter;
                    break;
                }
                if (annotationCounter < 1) {
                    for (DocletTag docletTag : paramTags) {
                        if (!DocClassUtil.isRequiredTag(docletTag.getName())) continue;
                        strRequired = true;
                        break;
                    }
                }
                if (StringUtil.isNotEmpty((String)(comment = null != (customResponseField = responseFieldMap.get(field.getName())) && StringUtil.isNotEmpty((String)customResponseField.getDesc()) ? customResponseField.getDesc() : field.getComment()))) {
                    comment = comment.replace("\r\n", "<br>");
                    comment = comment.replace("\n", "<br>");
                }
                if (DocClassUtil.isPrimitive(subTypeName)) {
                    param = ApiParam.of().setField(pre + fieldName);
                    processedType = DocClassUtil.processTypeNameForParams(typeSimpleName.toLowerCase());
                    param.setType(processedType);
                    if (StringUtil.isNotEmpty((String)comment)) {
                        this.commonHandleParam(paramList, param, isRequired, comment, since, strRequired);
                        continue;
                    }
                    this.commonHandleParam(paramList, param, isRequired, NO_COMMENTS_FOUND, since, strRequired);
                    continue;
                }
                param = ApiParam.of().setField(pre + fieldName);
                processedType = DocClassUtil.processTypeNameForParams(typeSimpleName.toLowerCase());
                param.setType(processedType);
                if (StringUtil.isNotEmpty((String)comment)) {
                    this.commonHandleParam(paramList, param, isRequired, comment, since, strRequired);
                } else {
                    this.commonHandleParam(paramList, param, isRequired, NO_COMMENTS_FOUND, since, strRequired);
                }
                StringBuilder preBuilder = new StringBuilder();
                for (int j = 0; j < i; ++j) {
                    preBuilder.append("&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;");
                }
                preBuilder.append("\u2514\u2500");
                if (DocClassUtil.isMap(subTypeName)) {
                    String gNameTemp = field.getType().getGenericCanonicalName();
                    if (MAP_CLASS.equals(gNameTemp)) {
                        ApiParam param1 = ApiParam.of().setField(preBuilder.toString() + "any object").setType("object").setDesc("any object.").setVersion("-");
                        paramList.add(param1);
                        continue;
                    }
                    String valType = DocClassUtil.getMapKeyValueType(gNameTemp)[1];
                    if (DocClassUtil.isPrimitive(valType)) continue;
                    if (valType.length() == 1) {
                        String gicName = n < globGicName.length ? globGicName[n] : globGicName[globGicName.length - 1];
                        if (DocClassUtil.isPrimitive(gicName) || simpleName.equals(gicName)) continue;
                        paramList.addAll(this.buildParams(gicName, preBuilder.toString(), i + 1, isRequired, responseFieldMap, isResp, false));
                        continue;
                    }
                    paramList.addAll(this.buildParams(valType, preBuilder.toString(), i + 1, isRequired, responseFieldMap, isResp, false));
                    continue;
                }
                if (DocClassUtil.isCollection(subTypeName)) {
                    String gNameTemp = field.getType().getGenericCanonicalName();
                    String[] gNameArr = DocClassUtil.getSimpleGicName(gNameTemp);
                    if (gNameArr.length == 0 || DocClassUtil.isPrimitive(gName = DocClassUtil.getSimpleGicName(gNameTemp)[0]) || simpleName.equals(gName) || gName.equals(simpleName)) continue;
                    if (gName.length() == 1) {
                        String gicName;
                        int len = globGicName.length;
                        if (len <= 0 || DocClassUtil.isPrimitive(gicName = n < len ? globGicName[n] : globGicName[len - 1]) || simpleName.equals(gicName)) continue;
                        paramList.addAll(this.buildParams(gicName, preBuilder.toString(), i + 1, isRequired, responseFieldMap, isResp, false));
                        continue;
                    }
                    JavaClass javaClass = this.javaFilesMap.get(gName);
                    List<JavaField> javaFields = this.getFields(javaClass, 0);
                    boolean isNotCircularReference = true;
                    for (JavaField field1 : javaFields) {
                        String fieldGicName1 = field1.getType().getGenericCanonicalName();
                        if (!fieldGicName1.contains(className)) continue;
                        isNotCircularReference = false;
                        break;
                    }
                    if (isNotCircularReference) {
                        paramList.addAll(this.buildParams(gName, preBuilder.toString(), i + 1, isRequired, responseFieldMap, isResp, false));
                        continue;
                    }
                    paramList.addAll(this.buildParams(gName, preBuilder.toString(), i + 1, isRequired, responseFieldMap, isResp, true));
                    continue;
                }
                if (subTypeName.length() == 1 || "java.lang.Object".equals(subTypeName)) {
                    if (!simpleName.equals(className)) {
                        if (n < globGicName.length) {
                            String gicName = globGicName[n];
                            String simple = DocClassUtil.getSimpleName(gicName);
                            if (!DocClassUtil.isPrimitive(simple)) {
                                if (gicName.contains("<")) {
                                    if (DocClassUtil.isCollection(simple)) {
                                        gName = DocClassUtil.getSimpleGicName(gicName)[0];
                                        if (!DocClassUtil.isPrimitive(gName)) {
                                            paramList.addAll(this.buildParams(gName, preBuilder.toString(), i + 1, isRequired, responseFieldMap, isResp, false));
                                        }
                                    } else if (DocClassUtil.isMap(simple)) {
                                        String valType = DocClassUtil.getMapKeyValueType(gicName)[1];
                                        if (!DocClassUtil.isPrimitive(valType)) {
                                            paramList.addAll(this.buildParams(valType, preBuilder.toString(), i + 1, isRequired, responseFieldMap, isResp, false));
                                        }
                                    } else {
                                        paramList.addAll(this.buildParams(gicName, preBuilder.toString(), i + 1, isRequired, responseFieldMap, isResp, false));
                                    }
                                } else {
                                    paramList.addAll(this.buildParams(gicName, preBuilder.toString(), i + 1, isRequired, responseFieldMap, isResp, false));
                                }
                            }
                        } else {
                            paramList.addAll(this.buildParams(subTypeName, preBuilder.toString(), i + 1, isRequired, responseFieldMap, isResp, false));
                        }
                    }
                    ++n;
                    continue;
                }
                if (DocClassUtil.isArray(subTypeName)) {
                    if (className.equals(fieldGicName = fieldGicName.substring(0, fieldGicName.indexOf("["))) || DocClassUtil.isPrimitive(fieldGicName)) continue;
                    paramList.addAll(this.buildParams(fieldGicName, preBuilder.toString(), i + 1, isRequired, responseFieldMap, isResp, false));
                    continue;
                }
                if (simpleName.equals(subTypeName)) continue;
                paramList.addAll(this.buildParams(fieldGicName, preBuilder.toString(), i + 1, isRequired, responseFieldMap, isResp, false));
            }
        }
        return paramList;
    }

    private JavaClass getJavaClass(String simpleName) {
        JavaClass cls = this.builder.getClassByName(simpleName);
        if (Objects.isNull(cls.getFields()) || cls.getFields().isEmpty()) {
            cls = this.javaFilesMap.get(simpleName);
        }
        return cls;
    }

    private List<ApiParam> primitiveReturnRespComment(String typeName) {
        StringBuilder comments = new StringBuilder();
        comments.append("The api directly returns the ").append(typeName).append(" type value.");
        ApiParam apiParam = ApiParam.of().setField("no param name").setType(typeName).setDesc(comments.toString()).setVersion("-");
        ArrayList<ApiParam> paramList = new ArrayList<ApiParam>();
        paramList.add(apiParam);
        return paramList;
    }

    private String buildReturnJson(JavaMethod method, Map<String, CustomRespField> responseFieldMap) {
        if ("void".equals(method.getReturnType().getFullyQualifiedName())) {
            return "This api return nothing.";
        }
        ApiReturn apiReturn = DocClassUtil.processReturnType(method.getReturnType().getGenericCanonicalName());
        String returnType = apiReturn.getGenericCanonicalName();
        String typeName = apiReturn.getSimpleName();
        return JsonFormatUtil.formatJson((String)this.buildJson(typeName, returnType, responseFieldMap, true, 0, false));
    }

    private String buildJson(String typeName, String genericCanonicalName, Map<String, CustomRespField> responseFieldMap, boolean isResp, int counter, boolean isSkip) {
        if (counter > 2 && isSkip) {
            return "";
        }
        if (DocClassUtil.isMvcIgnoreParams(typeName)) {
            if ("org.springframework.web.servlet.ModelAndView".equals(typeName)) {
                return "Forward or redirect to a page view.";
            }
            return "Error restful return.";
        }
        if (DocClassUtil.isPrimitive(typeName)) {
            return DocUtil.jsonValueByType(typeName).replace("\"", "");
        }
        StringBuilder data0 = new StringBuilder();
        JavaClass cls = this.getJavaClass(typeName);
        data0.append("{");
        String[] globGicName = DocClassUtil.getSimpleGicName(genericCanonicalName);
        StringBuilder data = new StringBuilder();
        if (DocClassUtil.isCollection(typeName) || DocClassUtil.isArray(typeName)) {
            String gName;
            data.append("[");
            if (globGicName.length == 0) {
                data.append("{\"object\":\"any object\"}");
                data.append("]");
                return data.toString();
            }
            String gNameTemp = globGicName[0];
            String string = gName = DocClassUtil.isArray(typeName) ? gNameTemp.substring(0, gNameTemp.indexOf("[")) : globGicName[0];
            if ("java.lang.Object".equals(gName)) {
                data.append("{\"waring\":\"You may use java.util.Object instead of display generics in the List\"}");
            } else if (DocClassUtil.isPrimitive(gName)) {
                data.append(DocUtil.jsonValueByType(gName)).append(",");
                data.append(DocUtil.jsonValueByType(gName));
            } else if (gName.contains("<")) {
                String simple = DocClassUtil.getSimpleName(gName);
                String json = this.buildJson(simple, gName, responseFieldMap, isResp, counter + 1, false);
                data.append(json);
            } else if (DocClassUtil.isCollection(gName)) {
                data.append("\"any object\"");
            } else {
                String json = this.buildJson(gName, gName, responseFieldMap, isResp, counter + 1, false);
                data.append(json);
            }
            data.append("]");
            return data.toString();
        }
        if (DocClassUtil.isMap(typeName)) {
            String gNameTemp = genericCanonicalName;
            String[] getKeyValType = DocClassUtil.getMapKeyValueType(gNameTemp);
            if (getKeyValType.length == 0) {
                data.append("{\"mapKey\":{}}");
                return data.toString();
            }
            if (!"java.lang.String".equals(getKeyValType[0])) {
                throw new RuntimeException("Map's key can only use String for json,but you use " + getKeyValType[0]);
            }
            String gicName = gNameTemp.substring(gNameTemp.indexOf(",") + 1, gNameTemp.lastIndexOf(">"));
            if ("java.lang.Object".equals(gicName)) {
                data.append("{").append("\"mapKey\":").append("{\"waring\":\"You may use java.util.Object for Map value; smart-doc can't be handle.\"}").append("}");
            } else if (DocClassUtil.isPrimitive(gicName)) {
                data.append("{").append("\"mapKey1\":").append(DocUtil.jsonValueByType(gicName)).append(",");
                data.append("\"mapKey2\":").append(DocUtil.jsonValueByType(gicName)).append("}");
            } else if (gicName.contains("<")) {
                String simple = DocClassUtil.getSimpleName(gicName);
                String json = this.buildJson(simple, gicName, responseFieldMap, isResp, counter + 1, false);
                data.append("{").append("\"mapKey\":").append(json).append("}");
            } else {
                data.append("{").append("\"mapKey\":").append(this.buildJson(gicName, gNameTemp, responseFieldMap, isResp, counter + 1, false)).append("}");
            }
            return data.toString();
        }
        if ("java.lang.Object".equals(typeName)) {
            if ("java.lang.Object".equals(typeName)) {
                data.append("{\"object\":\" any object\"},");
            }
        } else {
            List<JavaField> fields = this.getFields(cls, 0);
            int i = 0;
            block0: for (JavaField field : fields) {
                String gicName1;
                String gicName;
                DocletTag docletTag2;
                String fieldName = field.getName();
                if ("serialVersionUID".equals(fieldName)) continue;
                List paramTags = field.getTags();
                if (!isResp) {
                    for (DocletTag docletTag2 : paramTags) {
                        if (!DocClassUtil.isIgnoreTag(docletTag2.getName())) continue;
                        continue block0;
                    }
                }
                List annotations = field.getAnnotations();
                docletTag2 = annotations.iterator();
                while (docletTag2.hasNext()) {
                    JavaAnnotation annotation = (JavaAnnotation)docletTag2.next();
                    String annotationName = annotation.getType().getSimpleName();
                    if ("JsonIgnore".equals(annotationName) && isResp) continue block0;
                    if ("JSONField".equals(annotationName) && isResp) {
                        if (null != annotation.getProperty("serialize")) {
                            if (!"false".equals(annotation.getProperty("serialize").toString())) continue;
                            continue block0;
                        }
                        if (null == annotation.getProperty("name")) continue;
                        fieldName = annotation.getProperty("name").toString().replace("\"", "");
                        continue;
                    }
                    if (!"JsonProperty".equals(annotationName) || !isResp || null == annotation.getProperty("value")) continue;
                    fieldName = annotation.getProperty("value").toString().replace("\"", "");
                }
                String typeSimpleName = field.getType().getSimpleName();
                String subTypeName = field.getType().getFullyQualifiedName();
                String fieldGicName = field.getType().getGenericCanonicalName();
                data0.append("\"").append(fieldName).append("\":");
                if (DocClassUtil.isPrimitive(typeSimpleName)) {
                    CustomRespField customResponseField = responseFieldMap.get(fieldName);
                    if (null != customResponseField) {
                        Object val = customResponseField.getValue();
                        if (null != val) {
                            if ("String".equals(typeSimpleName)) {
                                data0.append("\"").append(val).append("\",");
                                continue;
                            }
                            data0.append(val).append(",");
                            continue;
                        }
                        data0.append(DocUtil.getValByTypeAndFieldName(typeSimpleName, field.getName())).append(",");
                        continue;
                    }
                    data0.append(DocUtil.getValByTypeAndFieldName(typeSimpleName, field.getName())).append(",");
                    continue;
                }
                if (DocClassUtil.isCollection(subTypeName) || DocClassUtil.isArray(subTypeName)) {
                    String string = fieldGicName = DocClassUtil.isArray(subTypeName) ? fieldGicName.substring(0, fieldGicName.indexOf("[")) : fieldGicName;
                    if (DocClassUtil.getSimpleGicName(fieldGicName).length == 0) {
                        data0.append("{\"object\":\"any object\"},");
                        continue;
                    }
                    gicName = DocClassUtil.getSimpleGicName(fieldGicName)[0];
                    if ("java.lang.String".equals(gicName)) {
                        data0.append("[").append("\"").append(this.buildJson(gicName, fieldGicName, responseFieldMap, isResp, counter + 1, false)).append("\"]").append(",");
                        continue;
                    }
                    if ("java.util.List".equals(gicName)) {
                        data0.append("{\"object\":\"any object\"},");
                        continue;
                    }
                    if (gicName.length() == 1) {
                        if (globGicName.length == 0) {
                            data0.append("{\"object\":\"any object\"},");
                            continue;
                        }
                        String string2 = gicName1 = i < globGicName.length ? globGicName[i] : globGicName[globGicName.length - 1];
                        if ("java.lang.String".equals(gicName1)) {
                            data0.append("[").append("\"").append(this.buildJson(gicName1, gicName1, responseFieldMap, isResp, counter + 1, false)).append("\"]").append(",");
                            continue;
                        }
                        if (!typeName.equals(gicName1)) {
                            data0.append("[").append(this.buildJson(DocClassUtil.getSimpleName(gicName1), gicName1, responseFieldMap, isResp, counter + 1, false)).append("]").append(",");
                            continue;
                        }
                        data0.append("[{\"$ref\":\"..\"}]").append(",");
                        continue;
                    }
                    if (!typeName.equals(gicName)) {
                        if (MAP_CLASS.equals(gicName)) {
                            data0.append("[{\"mapKey\":{}}],");
                            continue;
                        }
                        JavaClass javaClass = this.javaFilesMap.get(gicName);
                        List<JavaField> javaFields = this.getFields(javaClass, 0);
                        boolean isNotCircularReference = true;
                        for (JavaField field1 : javaFields) {
                            String fieldGicName1 = field1.getType().getGenericCanonicalName();
                            if (!fieldGicName1.contains(typeName)) continue;
                            isNotCircularReference = false;
                            break;
                        }
                        if (isNotCircularReference) {
                            data0.append("[").append(this.buildJson(gicName, fieldGicName, responseFieldMap, isResp, counter + 1, false)).append("]").append(",");
                            continue;
                        }
                        data0.append("[").append(this.buildJson(gicName, fieldGicName, responseFieldMap, isResp, counter + 1, true)).append("]").append(",");
                        continue;
                    }
                    data0.append("[{\"$ref\":\"..\"}]").append(",");
                    continue;
                }
                if (DocClassUtil.isMap(subTypeName)) {
                    if (MAP_CLASS.equals(subTypeName)) {
                        data0.append("{").append("\"mapKey\":{}},");
                        continue;
                    }
                    gicName = fieldGicName.substring(fieldGicName.indexOf(",") + 1, fieldGicName.indexOf(">"));
                    if (gicName.length() == 1) {
                        String string = gicName1 = i < globGicName.length ? globGicName[i] : globGicName[globGicName.length - 1];
                        if ("java.lang.String".equals(gicName1)) {
                            data0.append("{").append("\"mapKey\":\"").append(this.buildJson(gicName1, gicName1, responseFieldMap, isResp, counter + 1, false)).append("\"},");
                            continue;
                        }
                        if (!typeName.equals(gicName1)) {
                            data0.append("{").append("\"mapKey\":").append(this.buildJson(DocClassUtil.getSimpleName(gicName1), gicName1, responseFieldMap, isResp, counter + 1, false)).append("},");
                            continue;
                        }
                        data0.append("{\"mapKey\":{}},");
                        continue;
                    }
                    data0.append("{").append("\"mapKey\":").append(this.buildJson(gicName, fieldGicName, responseFieldMap, isResp, counter + 1, false)).append("},");
                    continue;
                }
                if (subTypeName.length() == 1) {
                    if (!typeName.equals(genericCanonicalName)) {
                        gicName = globGicName[i];
                        if (gicName.contains("<")) {
                            String simple = DocClassUtil.getSimpleName(gicName);
                            data0.append(this.buildJson(simple, gicName, responseFieldMap, isResp, counter + 1, false)).append(",");
                        } else if (DocClassUtil.isPrimitive(gicName)) {
                            data0.append(DocUtil.jsonValueByType(gicName)).append(",");
                        } else {
                            data0.append(this.buildJson(gicName, gicName, responseFieldMap, isResp, counter + 1, false)).append(",");
                        }
                    } else {
                        data0.append("{\"waring\":\"You may have used non-display generics.\"},");
                    }
                    ++i;
                    continue;
                }
                if ("java.lang.Object".equals(subTypeName)) {
                    if (i < globGicName.length) {
                        gicName = globGicName[i];
                        if (!typeName.equals(genericCanonicalName)) {
                            if (DocClassUtil.isPrimitive(gicName)) {
                                data0.append("\"").append(this.buildJson(gicName, genericCanonicalName, responseFieldMap, isResp, counter + 1, false)).append("\",");
                                continue;
                            }
                            data0.append(this.buildJson(gicName, gicName, responseFieldMap, isResp, counter + 1, false)).append(",");
                            continue;
                        }
                        data0.append("{\"waring\":\"You may have used non-display generics.\"},");
                        continue;
                    }
                    data0.append("{\"waring\":\"You may have used non-display generics.\"},");
                    continue;
                }
                if (typeName.equals(subTypeName)) {
                    data0.append("{\"$ref\":\"...\"}").append(",");
                    continue;
                }
                data0.append(this.buildJson(subTypeName, fieldGicName, responseFieldMap, isResp, counter + 1, false)).append(",");
            }
        }
        if (data0.toString().contains(",")) {
            data0.deleteCharAt(data0.lastIndexOf(","));
        }
        data0.append("}");
        return data0.toString();
    }

    private String buildReqJson(JavaMethod method, ApiMethodDoc apiMethodDoc, boolean isPostMethod) {
        String url;
        List parameterList = method.getParameters();
        if (parameterList.size() < 1) {
            return apiMethodDoc.getUrl();
        }
        boolean containsBrace = apiMethodDoc.getUrl().contains("{");
        LinkedHashMap<String, String> paramsMap = new LinkedHashMap<String, String>();
        for (JavaParameter parameter : parameterList) {
            JavaType javaType = parameter.getType();
            String simpleTypeName = javaType.getValue();
            String gicTypeName = javaType.getGenericCanonicalName();
            String typeName = javaType.getFullyQualifiedName();
            String paraName = parameter.getName();
            if (DocClassUtil.isMvcIgnoreParams(typeName)) continue;
            List annotations = parameter.getAnnotations();
            int requestBodyCounter = 0;
            String defaultVal = null;
            boolean notHasRequestParams = true;
            for (JavaAnnotation annotation : annotations) {
                AnnotationValue annotationOfName;
                AnnotationValue annotationValue;
                AnnotationValue annotationDefaultVal;
                String annotationName = annotation.getType().getSimpleName();
                if (REQUEST_BODY.equals(annotationName) || "org.springframework.web.bind.annotation.RequestBody".equals(annotationName)) {
                    ++requestBodyCounter;
                    apiMethodDoc.setContentType(JSON_CONTENT_TYPE);
                    if (DocClassUtil.isPrimitive(simpleTypeName)) {
                        StringBuilder builder = new StringBuilder();
                        builder.append("{\"").append(paraName).append("\":").append(DocUtil.jsonValueByType(simpleTypeName)).append("}");
                        return builder.toString();
                    }
                    return this.buildJson(typeName, gicTypeName, this.fieldMap, false, 0, false);
                }
                if (REQUEST_PARAM.equals(annotationName)) {
                    notHasRequestParams = false;
                }
                if (null != (annotationDefaultVal = annotation.getProperty("defaultValue"))) {
                    defaultVal = StringUtil.removeQuotes((String)annotationDefaultVal.toString());
                }
                if (null != (annotationValue = annotation.getProperty("value"))) {
                    paraName = StringUtil.removeQuotes((String)annotationValue.toString());
                }
                if (null != (annotationOfName = annotation.getProperty("name"))) {
                    paraName = StringUtil.removeQuotes((String)annotationOfName.toString());
                }
                if (!REQUEST_HERDER.equals(annotationName)) continue;
                paraName = null;
            }
            if (DocClassUtil.isPrimitive(typeName) && parameterList.size() == 1 && isPostMethod && notHasRequestParams && !containsBrace) {
                apiMethodDoc.setContentType(JSON_CONTENT_TYPE);
                StringBuilder builder = new StringBuilder();
                builder.append("{\"").append(paraName).append("\":").append(DocUtil.jsonValueByType(simpleTypeName)).append("}");
                return builder.toString();
            }
            if (requestBodyCounter >= true || paraName == null) continue;
            if (annotations.size() < 1 && !DocClassUtil.isPrimitive(typeName)) {
                return "Smart-doc can't support create form-data example,It is recommended to use @RequestBody to receive parameters.";
            }
            if (StringUtil.isEmpty(defaultVal)) {
                paramsMap.put(paraName, DocUtil.getValByTypeAndFieldName(simpleTypeName, paraName, true));
                continue;
            }
            paramsMap.put(paraName, defaultVal);
        }
        if (containsBrace) {
            url = DocUtil.formatAndRemove(apiMethodDoc.getUrl(), paramsMap);
            url = UrlUtil.urlJoin((String)url, paramsMap);
        } else {
            url = UrlUtil.urlJoin((String)apiMethodDoc.getUrl(), paramsMap);
        }
        return url;
    }

    private List<ApiParam> requestParams(JavaMethod javaMethod, String tagName, String className) {
        HashMap<String, CustomRespField> responseFieldMap = new HashMap<String, CustomRespField>();
        Map<String, String> paramTagMap = DocUtil.getParamsComments(javaMethod, tagName, className);
        List parameterList = javaMethod.getParameters();
        if (parameterList.size() > 0) {
            ArrayList<ApiParam> paramList = new ArrayList<ApiParam>();
            int requestBodyCounter = 0;
            ArrayList<ApiParam> reqBodyParamsList = new ArrayList<ApiParam>();
            block0: for (JavaParameter parameter : parameterList) {
                List annotations;
                String paramName = parameter.getName();
                String typeName = parameter.getType().getGenericCanonicalName();
                String simpleName = parameter.getType().getValue().toLowerCase();
                String fullTypeName = parameter.getType().getFullyQualifiedName();
                if (DocClassUtil.isMvcIgnoreParams(typeName)) continue;
                if (!paramTagMap.containsKey(paramName) && DocClassUtil.isPrimitive(fullTypeName) && this.isStrict) {
                    throw new RuntimeException("ERROR: Unable to find javadoc @param for actual param \"" + paramName + "\" in method " + javaMethod.getName() + " from " + className);
                }
                String comment = paramTagMap.get(paramName);
                if (StringUtil.isEmpty((String)comment)) {
                    comment = NO_COMMENTS_FOUND;
                }
                if ((annotations = parameter.getAnnotations()).size() == 0) {
                    ApiParam param;
                    if (DocClassUtil.isCollection(fullTypeName) || DocClassUtil.isArray(fullTypeName)) {
                        ApiParam param2;
                        String[] gicNameArr = DocClassUtil.getSimpleGicName(typeName);
                        String gicName = gicNameArr[0];
                        if (DocClassUtil.isArray(gicName)) {
                            gicName = gicName.substring(0, gicName.indexOf("["));
                        }
                        String typeTemp = "";
                        if (DocClassUtil.isPrimitive(gicName)) {
                            typeTemp = " of " + DocClassUtil.processTypeNameForParams(gicName);
                            param2 = ApiParam.of().setField(paramName).setType(DocClassUtil.processTypeNameForParams(simpleName) + typeTemp).setDesc(comment).setRequired(true).setVersion("-");
                            paramList.add(param2);
                        } else {
                            param2 = ApiParam.of().setField(paramName).setType(DocClassUtil.processTypeNameForParams(simpleName) + typeTemp).setDesc(comment).setRequired(true).setVersion("-");
                            paramList.add(param2);
                            paramList.addAll(this.buildParams(gicNameArr[0], "\u2514\u2500", 1, "true", responseFieldMap, false, false));
                        }
                    } else if (DocClassUtil.isPrimitive(simpleName)) {
                        param = ApiParam.of().setField(paramName).setType(DocClassUtil.processTypeNameForParams(simpleName)).setDesc(comment).setRequired(true).setVersion("-");
                        paramList.add(param);
                    } else if (MAP_CLASS.equals(typeName)) {
                        param = ApiParam.of().setField(paramName).setType("map").setDesc(comment).setRequired(true).setVersion("-");
                        paramList.add(param);
                    } else {
                        paramList.addAll(this.buildParams(fullTypeName, "", 0, "true", responseFieldMap, false, false));
                    }
                }
                for (JavaAnnotation annotation : annotations) {
                    AnnotationValue annotationOfName;
                    String annotationName;
                    String required = "true";
                    AnnotationValue annotationRequired = annotation.getProperty("required");
                    if (null != annotationRequired) {
                        required = annotationRequired.toString();
                    }
                    if (REQUEST_BODY.equals(annotationName = annotation.getType().getName()) || VALID.equals(annotationName) && annotations.size() == 1) {
                        String[] gicNameArr;
                        if (requestBodyCounter > 0) {
                            throw new RuntimeException("You have use @RequestBody Passing multiple variables  for method " + javaMethod.getName() + " in " + className + ",@RequestBody annotation could only bind one variables.");
                        }
                        if (DocClassUtil.isPrimitive(fullTypeName)) {
                            ApiParam bodyParam = ApiParam.of().setField(paramName).setType(DocClassUtil.processTypeNameForParams(simpleName)).setDesc(comment).setRequired(Boolean.valueOf(required));
                            reqBodyParamsList.add(bodyParam);
                        } else if (DocClassUtil.isCollection(fullTypeName) || DocClassUtil.isArray(fullTypeName)) {
                            gicNameArr = DocClassUtil.getSimpleGicName(typeName);
                            String gicName = gicNameArr[0];
                            if (DocClassUtil.isArray(gicName)) {
                                gicName = gicName.substring(0, gicName.indexOf("["));
                            }
                            if (DocClassUtil.isPrimitive(gicName)) {
                                ApiParam bodyParam = ApiParam.of().setField(paramName).setType(DocClassUtil.processTypeNameForParams(simpleName)).setDesc(comment).setRequired(Boolean.valueOf(required)).setVersion("-");
                                reqBodyParamsList.add(bodyParam);
                            } else {
                                reqBodyParamsList.addAll(this.buildParams(gicNameArr[0], "", 0, "true", responseFieldMap, false, false));
                            }
                        } else if (DocClassUtil.isMap(fullTypeName)) {
                            if (MAP_CLASS.equals(typeName)) {
                                ApiParam apiParam = ApiParam.of().setField(paramName).setType("map").setDesc(comment).setRequired(Boolean.valueOf(required)).setVersion("-");
                                paramList.add(apiParam);
                                continue block0;
                            }
                            gicNameArr = DocClassUtil.getSimpleGicName(typeName);
                            reqBodyParamsList.addAll(this.buildParams(gicNameArr[1], "", 0, "true", responseFieldMap, false, false));
                        } else {
                            reqBodyParamsList.addAll(this.buildParams(typeName, "", 0, "true", responseFieldMap, false, false));
                        }
                        ++requestBodyCounter;
                        continue;
                    }
                    if (!REQUEST_PARAM.equals(annotationName) && !"PathVariable".equals(annotationName)) continue;
                    AnnotationValue annotationValue = annotation.getProperty("value");
                    if (null != annotationValue) {
                        paramName = StringUtil.removeQuotes((String)annotationValue.toString());
                    }
                    if (null != (annotationOfName = annotation.getProperty("name"))) {
                        paramName = StringUtil.removeQuotes((String)annotationOfName.toString());
                    }
                    ApiParam param = ApiParam.of().setField(paramName).setType(DocClassUtil.processTypeNameForParams(simpleName)).setDesc(comment).setRequired(Boolean.valueOf(required)).setVersion("-");
                    paramList.add(param);
                }
            }
            if (requestBodyCounter > 0) {
                paramList.addAll(reqBodyParamsList);
                return paramList;
            }
            return paramList;
        }
        return null;
    }

    private List<JavaField> getFields(JavaClass cls1, int i) {
        ArrayList<JavaField> fieldList = new ArrayList<JavaField>();
        if (null == cls1) {
            return fieldList;
        }
        if ("Object".equals(cls1.getSimpleName()) || "Timestamp".equals(cls1.getSimpleName()) || "Date".equals(cls1.getSimpleName()) || "Locale".equals(cls1.getSimpleName())) {
            return fieldList;
        }
        JavaClass pcls = cls1.getSuperJavaClass();
        fieldList.addAll(this.getFields(pcls, i));
        fieldList.addAll(cls1.getFields());
        return fieldList;
    }

    private boolean checkController(JavaClass cls) {
        List classAnnotations = cls.getAnnotations();
        for (JavaAnnotation annotation : classAnnotations) {
            String annotationName = annotation.getType().getName();
            if (!"Controller".equals(annotationName) && !"RestController".equals(annotationName) && !"org.springframework.web.bind.annotation.RestController".equals(annotationName) && !"org.springframework.stereotype.Controller".equals(annotationName)) continue;
            return true;
        }
        return false;
    }

    private void handControllerAlias(ApiDoc apiDoc) {
        if (this.isUseMD5) {
            String name = DigestUtils.md5Hex((String)apiDoc.getName());
            int length = name.length();
            if (name.length() < 32) {
                apiDoc.setAlias(name);
            } else {
                apiDoc.setAlias(name.substring(length - 32, length));
            }
        }
    }

    private void handleMethodUid(ApiMethodDoc methodDoc, String methodName) {
        String name = DigestUtils.md5Hex((String)methodName);
        int length = name.length();
        if (name.length() < 32) {
            methodDoc.setMethodId(name);
        } else {
            methodDoc.setMethodId(name.substring(length - 32, length));
        }
    }

    private void commonHandleParam(List<ApiParam> paramList, ApiParam param, String isRequired, String comment, String since, boolean strRequired) {
        if (StringUtil.isEmpty((String)isRequired)) {
            param.setDesc(comment).setVersion(since);
            paramList.add(param);
        } else {
            param.setDesc(comment).setVersion(since).setRequired(strRequired);
            paramList.add(param);
        }
    }

    private void handleApiDoc(JavaClass cls, List<ApiDoc> apiDocList, int order) {
        List<ApiMethodDoc> apiMethodDocs = this.buildControllerMethod(cls);
        String controllerName = cls.getName();
        ApiDoc apiDoc = new ApiDoc();
        apiDoc.setOrder(order);
        apiDoc.setName(controllerName);
        apiDoc.setAlias(controllerName);
        this.handControllerAlias(apiDoc);
        apiDoc.setDesc(cls.getComment());
        apiDoc.setList(apiMethodDocs);
        apiDocList.add(apiDoc);
    }
}

