/*
 * Decompiled with CFR 0.152.
 */
package com.power.doc.builder;

import com.power.common.util.CollectionUtil;
import com.power.common.util.DateTimeUtil;
import com.power.common.util.FileUtil;
import com.power.doc.builder.DocBuilderTemplate;
import com.power.doc.builder.SourceBuilder;
import com.power.doc.constants.DocGlobalConstants;
import com.power.doc.constants.DocLanguage;
import com.power.doc.constants.TemplateVariable;
import com.power.doc.model.ApiConfig;
import com.power.doc.model.ApiDoc;
import com.power.doc.model.ApiErrorCode;
import com.power.doc.utils.BeetlTemplateUtil;
import com.power.doc.utils.MarkDownUtil;
import java.util.List;
import org.beetl.core.Template;

public class HtmlApiDocBuilder {
    private static long now = System.currentTimeMillis();
    private static String INDEX_HTML = "index.html";

    public static void builderControllersApi(ApiConfig config) {
        DocBuilderTemplate builderTemplate = new DocBuilderTemplate();
        builderTemplate.checkAndInit(config);
        SourceBuilder sourceBuilder = new SourceBuilder(config);
        List<ApiDoc> apiDocList = sourceBuilder.getControllerApiData();
        if (config.isAllInOne()) {
            Template indexCssTemplate = BeetlTemplateUtil.getByName("AllInOne.css");
            FileUtil.nioWriteFile((String)indexCssTemplate.render(), (String)(config.getOutPath() + DocGlobalConstants.FILE_SEPARATOR + "AllInOne.css"));
            builderTemplate.buildAllInOne(apiDocList, config, "AllInOne.html", INDEX_HTML);
        } else {
            HtmlApiDocBuilder.buildIndex(apiDocList, config);
            HtmlApiDocBuilder.copyCss(config.getOutPath());
            HtmlApiDocBuilder.buildApiDoc(apiDocList, config.getOutPath());
            HtmlApiDocBuilder.buildErrorCodeDoc(config.getErrorCodes(), config.getOutPath());
        }
    }

    private static void copyCss(String outPath) {
        Template indexCssTemplate = BeetlTemplateUtil.getByName("index.css");
        Template mdCssTemplate = BeetlTemplateUtil.getByName("markdown.css");
        FileUtil.nioWriteFile((String)indexCssTemplate.render(), (String)(outPath + DocGlobalConstants.FILE_SEPARATOR + "index.css"));
        FileUtil.nioWriteFile((String)mdCssTemplate.render(), (String)(outPath + DocGlobalConstants.FILE_SEPARATOR + "markdown.css"));
    }

    private static void buildIndex(List<ApiDoc> apiDocList, ApiConfig config) {
        FileUtil.mkdirs((String)config.getOutPath());
        Template indexTemplate = BeetlTemplateUtil.getByName("Index.btl");
        if (CollectionUtil.isEmpty(apiDocList)) {
            return;
        }
        ApiDoc doc = apiDocList.get(0);
        String homePage = doc.getAlias();
        indexTemplate.binding(TemplateVariable.HOME_PAGE.getVariable(), (Object)homePage);
        indexTemplate.binding(TemplateVariable.API_DOC_LIST.getVariable(), apiDocList);
        indexTemplate.binding(TemplateVariable.VERSION.getVariable(), (Object)now);
        if (null != config.getLanguage()) {
            if (DocLanguage.CHINESE.code.equals(config.getLanguage().getCode())) {
                indexTemplate.binding(TemplateVariable.ERROR_LIST_TITLE.getVariable(), (Object)"\u9519\u8bef\u7801\u5217\u8868");
            } else {
                indexTemplate.binding(TemplateVariable.ERROR_LIST_TITLE.getVariable(), (Object)"Error Code List");
            }
        } else {
            indexTemplate.binding(TemplateVariable.ERROR_LIST_TITLE.getVariable(), (Object)"\u9519\u8bef\u7801\u5217\u8868");
        }
        FileUtil.nioWriteFile((String)indexTemplate.render(), (String)(config.getOutPath() + DocGlobalConstants.FILE_SEPARATOR + "api.html"));
    }

    private static void buildApiDoc(List<ApiDoc> apiDocList, String outPath) {
        FileUtil.mkdirs((String)outPath);
        String strTime = DateTimeUtil.long2Str((long)now, (String)"yyyy-MM-dd HH:mm:ss");
        for (ApiDoc doc : apiDocList) {
            Template apiTemplate = BeetlTemplateUtil.getByName("ApiDoc.btl");
            apiTemplate.binding(TemplateVariable.DESC.getVariable(), (Object)doc.getDesc());
            apiTemplate.binding(TemplateVariable.NAME.getVariable(), (Object)doc.getName());
            apiTemplate.binding(TemplateVariable.LIST.getVariable(), doc.getList());
            String html = MarkDownUtil.toHtml(apiTemplate.render());
            Template htmlApiDoc = BeetlTemplateUtil.getByName("HtmlApiDoc.btl");
            htmlApiDoc.binding(TemplateVariable.HTML.getVariable(), (Object)html);
            htmlApiDoc.binding(TemplateVariable.TITLE.getVariable(), (Object)doc.getDesc());
            htmlApiDoc.binding(TemplateVariable.CREATE_TIME.getVariable(), (Object)strTime);
            htmlApiDoc.binding(TemplateVariable.VERSION.getVariable(), (Object)now);
            FileUtil.nioWriteFile((String)htmlApiDoc.render(), (String)(outPath + DocGlobalConstants.FILE_SEPARATOR + doc.getAlias() + ".html"));
        }
    }

    private static void buildErrorCodeDoc(List<ApiErrorCode> errorCodeList, String outPath) {
        if (CollectionUtil.isNotEmpty(errorCodeList)) {
            Template error = BeetlTemplateUtil.getByName("ErrorCodeList.btl");
            error.binding(TemplateVariable.LIST.getVariable(), errorCodeList);
            String errorHtml = MarkDownUtil.toHtml(error.render());
            Template errorCodeDoc = BeetlTemplateUtil.getByName("HtmlApiDoc.btl");
            errorCodeDoc.binding(TemplateVariable.VERSION.getVariable(), (Object)now);
            errorCodeDoc.binding(TemplateVariable.TITLE.getVariable(), (Object)"Error Code List");
            errorCodeDoc.binding(TemplateVariable.HTML.getVariable(), (Object)errorHtml);
            errorCodeDoc.binding(TemplateVariable.CREATE_TIME.getVariable(), (Object)DateTimeUtil.long2Str((long)now, (String)"yyyy-MM-dd HH:mm:ss"));
            FileUtil.nioWriteFile((String)errorCodeDoc.render(), (String)(outPath + DocGlobalConstants.FILE_SEPARATOR + "error_code.html"));
        }
    }
}

