/*
 * Decompiled with CFR 0.152.
 */
package com.power.doc.builder;

import com.power.common.util.CollectionUtil;
import com.power.common.util.DateTimeUtil;
import com.power.common.util.FileUtil;
import com.power.common.util.StringUtil;
import com.power.doc.builder.SourceBuilder;
import com.power.doc.constants.DocGlobalConstants;
import com.power.doc.constants.DocLanguage;
import com.power.doc.constants.TemplateVariable;
import com.power.doc.model.ApiConfig;
import com.power.doc.model.ApiDoc;
import com.power.doc.model.ApiErrorCode;
import com.power.doc.utils.BeetlTemplateUtil;
import java.util.List;
import org.beetl.core.Template;

public class DocBuilderTemplate {
    private static long now = System.currentTimeMillis();

    public void checkAndInit(ApiConfig config) {
        if (null == config) {
            throw new NullPointerException("ApiConfig can't be null");
        }
        if (StringUtil.isEmpty((String)config.getOutPath())) {
            throw new RuntimeException("doc output path can't be null or empty");
        }
        if (null != config.getLanguage()) {
            System.setProperty("smart-doc_language", config.getLanguage().getCode());
        } else {
            System.setProperty("smart-doc_language", DocLanguage.CHINESE.getCode());
        }
    }

    public void checkAndInitForGetApiData(ApiConfig config) {
        if (null == config) {
            throw new NullPointerException("ApiConfig can't be null");
        }
        if (null != config.getLanguage()) {
            System.setProperty("smart-doc_language", config.getLanguage().getCode());
        } else {
            System.setProperty("smart-doc_language", DocLanguage.CHINESE.getCode());
        }
    }

    public void buildApiDoc(List<ApiDoc> apiDocList, ApiConfig config, String template, String fileExtension) {
        FileUtil.mkdirs((String)config.getOutPath());
        for (ApiDoc doc : apiDocList) {
            Template mapper = BeetlTemplateUtil.getByName(template);
            mapper.binding(TemplateVariable.DESC.getVariable(), (Object)doc.getDesc());
            mapper.binding(TemplateVariable.NAME.getVariable(), (Object)doc.getName());
            mapper.binding(TemplateVariable.LIST.getVariable(), doc.getList());
            FileUtil.nioWriteFile((String)mapper.render(), (String)(config.getOutPath() + DocGlobalConstants.FILE_SEPARATOR + doc.getName() + fileExtension));
        }
    }

    public void buildAllInOne(List<ApiDoc> apiDocList, ApiConfig config, String template, String outPutFileName) {
        String outPath = config.getOutPath();
        String strTime = DateTimeUtil.long2Str((long)now, (String)"yyyy-MM-dd HH:mm:ss");
        FileUtil.mkdirs((String)outPath);
        Template tpl = BeetlTemplateUtil.getByName(template);
        tpl.binding(TemplateVariable.API_DOC_LIST.getVariable(), apiDocList);
        tpl.binding(TemplateVariable.ERROR_CODE_LIST.getVariable(), config.getErrorCodes());
        tpl.binding(TemplateVariable.VERSION_LIST.getVariable(), config.getRevisionLogs());
        tpl.binding(TemplateVariable.VERSION.getVariable(), (Object)now);
        tpl.binding(TemplateVariable.CREATE_TIME.getVariable(), (Object)strTime);
        if (null != config.getLanguage()) {
            if (DocLanguage.CHINESE.code.equals(config.getLanguage().getCode())) {
                tpl.binding(TemplateVariable.ERROR_LIST_TITLE.getVariable(), (Object)"\u9519\u8bef\u7801\u5217\u8868");
            } else {
                tpl.binding(TemplateVariable.ERROR_LIST_TITLE.getVariable(), (Object)"Error Code List");
            }
        } else {
            tpl.binding(TemplateVariable.ERROR_LIST_TITLE.getVariable(), (Object)"\u9519\u8bef\u7801\u5217\u8868");
        }
        FileUtil.nioWriteFile((String)tpl.render(), (String)(outPath + DocGlobalConstants.FILE_SEPARATOR + outPutFileName));
    }

    public void buildErrorCodeDoc(List<ApiErrorCode> errorCodeList, ApiConfig config, String template, String outPutFileName) {
        if (CollectionUtil.isNotEmpty(errorCodeList)) {
            Template mapper = BeetlTemplateUtil.getByName(template);
            mapper.binding(TemplateVariable.LIST.getVariable(), errorCodeList);
            FileUtil.nioWriteFile((String)mapper.render(), (String)(config.getOutPath() + DocGlobalConstants.FILE_SEPARATOR + outPutFileName));
        }
    }

    public void buildSingleControllerApi(String outPath, String controllerName, String template, String fileExtension) {
        FileUtil.mkdirs((String)outPath);
        SourceBuilder sourceBuilder = new SourceBuilder(true);
        ApiDoc doc = sourceBuilder.getSingleControllerApiData(controllerName);
        Template mapper = BeetlTemplateUtil.getByName(template);
        mapper.binding(TemplateVariable.DESC.getVariable(), (Object)doc.getDesc());
        mapper.binding(TemplateVariable.NAME.getVariable(), (Object)doc.getName());
        mapper.binding(TemplateVariable.LIST.getVariable(), doc.getList());
        FileUtil.writeFileNotAppend((String)mapper.render(), (String)(outPath + DocGlobalConstants.FILE_SEPARATOR + doc.getName() + fileExtension));
    }
}

