/*
 * Decompiled with CFR 0.152.
 */
package com.power.doc.builder;

import com.power.common.util.DateTimeUtil;
import com.power.doc.builder.DocBuilderTemplate;
import com.power.doc.builder.SourceBuilder;
import com.power.doc.model.ApiConfig;
import com.power.doc.model.ApiDoc;
import java.util.List;

public class ApiDocBuilder {
    private static final String API_EXTENSION = "Api.md";
    private static final String DATE_FORMAT = "yyyyMMddHHmm";

    public static void builderControllersApi(ApiConfig config) {
        config.setAdoc(false);
        DocBuilderTemplate builderTemplate = new DocBuilderTemplate();
        builderTemplate.checkAndInit(config);
        SourceBuilder sourceBuilder = new SourceBuilder(config);
        List<ApiDoc> apiDocList = sourceBuilder.getControllerApiData();
        if (config.isAllInOne()) {
            String version = DateTimeUtil.long2Str((long)System.currentTimeMillis(), (String)DATE_FORMAT);
            builderTemplate.buildAllInOne(apiDocList, config, "AllInOne.btl", "AllInOne-V" + version + ".md");
        } else {
            builderTemplate.buildApiDoc(apiDocList, config, "ApiDoc.btl", API_EXTENSION);
            builderTemplate.buildErrorCodeDoc(config.getErrorCodes(), config, "ErrorCodeList.btl", "ErrorCodeList.md");
        }
    }

    public static void buildSingleControllerApi(ApiConfig config, String controllerName) {
        config.setAdoc(false);
        DocBuilderTemplate builderTemplate = new DocBuilderTemplate();
        builderTemplate.checkAndInit(config);
        builderTemplate.buildSingleControllerApi(config.getOutPath(), controllerName, "ApiDoc.btl", API_EXTENSION);
    }

    public static List<ApiDoc> listOfApiData(ApiConfig config) {
        DocBuilderTemplate builderTemplate = new DocBuilderTemplate();
        builderTemplate.checkAndInitForGetApiData(config);
        config.setMd5EncryptedHtmlName(true);
        SourceBuilder sourceBuilder = new SourceBuilder(config);
        return sourceBuilder.getControllerApiData();
    }

    public static ApiDoc getApiData(ApiConfig config, String controllerName) {
        DocBuilderTemplate builderTemplate = new DocBuilderTemplate();
        builderTemplate.checkAndInitForGetApiData(config);
        config.setMd5EncryptedHtmlName(true);
        SourceBuilder sourceBuilder = new SourceBuilder(config);
        return sourceBuilder.getSingleControllerApiData(controllerName);
    }
}

