/*
 * Decompiled with CFR 0.152.
 */
package com.power.doc.builder;

import com.power.doc.builder.DocBuilderTemplate;
import com.power.doc.builder.SourceBuilder;
import com.power.doc.model.ApiConfig;
import com.power.doc.model.ApiDoc;
import java.util.List;

public class AdocDocBuilder {
    private static final String API_EXTENSION = "Api.adoc";
    private static final String INDEX_DOC = "index.adoc";

    public static void builderControllersApi(ApiConfig config) {
        config.setAdoc(true);
        DocBuilderTemplate builderTemplate = new DocBuilderTemplate();
        builderTemplate.checkAndInit(config);
        SourceBuilder sourceBuilder = new SourceBuilder(config);
        List<ApiDoc> apiDocList = sourceBuilder.getControllerApiData();
        if (config.isAllInOne()) {
            builderTemplate.buildAllInOne(apiDocList, config, "AllInOne.adoc", INDEX_DOC);
        } else {
            builderTemplate.buildApiDoc(apiDocList, config, "ApiDoc.adoc", API_EXTENSION);
            builderTemplate.buildErrorCodeDoc(config.getErrorCodes(), config, "ErrorCodeList.btl", "ErrorCodeList.md");
        }
    }

    public static void buildSingleControllerApi(ApiConfig config, String controllerName) {
        config.setAdoc(true);
        DocBuilderTemplate builderTemplate = new DocBuilderTemplate();
        builderTemplate.checkAndInit(config);
        builderTemplate.buildSingleControllerApi(config.getOutPath(), controllerName, "ApiDoc.adoc", API_EXTENSION);
    }
}

