/*
 * Decompiled with CFR 0.152.
 */
package com.github.searls.jasmine.runner;

import com.github.searls.jasmine.io.FileUtilsWrapper;
import com.github.searls.jasmine.model.FileSystemReporter;
import com.github.searls.jasmine.model.JasmineResult;
import com.github.searls.jasmine.model.Reporter;
import com.github.searls.jasmine.runner.ConsoleErrorChecker;
import com.github.searls.jasmine.runner.WebDriverWaiter;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.List;
import org.apache.maven.plugin.logging.Log;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.WebDriver;

public class SpecRunnerExecutor {
    private final FileUtilsWrapper fileUtilsWrapper;
    private final WebDriverWaiter webDriverWaiter;
    private final ConsoleErrorChecker consoleErrorChecker;

    public SpecRunnerExecutor(FileUtilsWrapper fileUtilsWrapper, WebDriverWaiter webDriverWaiter, ConsoleErrorChecker consoleErrorChecker) {
        this.fileUtilsWrapper = fileUtilsWrapper;
        this.webDriverWaiter = webDriverWaiter;
        this.consoleErrorChecker = consoleErrorChecker;
    }

    public SpecRunnerExecutor() {
        this(new FileUtilsWrapper(), new WebDriverWaiter(), new ConsoleErrorChecker());
    }

    public JasmineResult execute(URL runnerUrl, WebDriver driver, int timeout, boolean debug, Log log, String format, List<Reporter> reporters, List<FileSystemReporter> fileSystemReporters) {
        try {
            if (!(driver instanceof JavascriptExecutor)) {
                throw new RuntimeException("The provided web driver can't execute JavaScript: " + driver.getClass());
            }
            JavascriptExecutor executor = (JavascriptExecutor)driver;
            driver.get(runnerUrl.toString());
            this.webDriverWaiter.waitForRunnerToFinish(driver, timeout, debug, log);
            this.consoleErrorChecker.checkForConsoleErrors(driver, log);
            this.storeFileSystemReports(fileSystemReporters, executor, debug);
            JasmineResult jasmineResult = new JasmineResult();
            jasmineResult.setDetails(this.buildReports(reporters, executor, format));
            JasmineResult jasmineResult2 = jasmineResult;
            return jasmineResult2;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            try {
                driver.quit();
            }
            catch (Exception e) {
                log.error((CharSequence)"There was an exception quitting WebDriver.", (Throwable)e);
            }
        }
    }

    private void storeFileSystemReports(List<FileSystemReporter> fileSystemReporters, JavascriptExecutor executor, boolean debug) throws IOException {
        for (FileSystemReporter reporter : fileSystemReporters) {
            this.fileUtilsWrapper.writeStringToFile(reporter.file, this.buildFileSystemReport(executor, reporter.reporterFile, debug));
        }
    }

    private String buildFileSystemReport(JavascriptExecutor driver, File reporter, boolean debug) throws IOException {
        String command = "return fileSystemReporter.report(window.jsApiReporter," + debug + ");";
        return this.executeReportCommand(driver, reporter, command);
    }

    private String buildReports(List<Reporter> reporters, JavascriptExecutor executor, String format) throws IOException {
        StringBuilder report = new StringBuilder();
        for (Reporter reporter : reporters) {
            report.append(this.buildReport(executor, reporter.reporterFile, format));
        }
        return report.toString();
    }

    private String buildReport(JavascriptExecutor driver, File reporter, String format) throws IOException {
        String command = "return jasmineMavenPlugin.printReport(window.jsApiReporter,{format:'" + format + "'});";
        return this.executeReportCommand(driver, reporter, command);
    }

    private String executeReportCommand(JavascriptExecutor driver, File reporter, String command) throws IOException {
        String script = this.fileUtilsWrapper.readFileToString(reporter) + command;
        Object report = driver.executeScript(script, new Object[0]);
        return report.toString();
    }
}

