/*
 * Decompiled with CFR 0.152.
 */
package com.github.searls.jasmine.mojo;

import com.github.searls.jasmine.config.JasmineConfiguration;
import com.github.searls.jasmine.exception.StringifiesStackTraces;
import com.github.searls.jasmine.io.ScansDirectory;
import com.github.searls.jasmine.model.FileSystemReporter;
import com.github.searls.jasmine.model.Reporter;
import com.github.searls.jasmine.model.ScriptSearch;
import com.github.searls.jasmine.mojo.Context;
import com.github.searls.jasmine.mojo.ReporterRetriever;
import com.github.searls.jasmine.mojo.ResourceRetriever;
import com.github.searls.jasmine.runner.SpecRunnerTemplate;
import com.github.searls.jasmine.thirdpartylibs.ProjectClassLoaderFactory;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.resource.ResourceManager;
import org.eclipse.jetty.server.Connector;

public abstract class AbstractJasmineMojo
extends AbstractMojo
implements JasmineConfiguration {
    @Parameter(property="jsSrcDir", defaultValue="${project.basedir}${file.separator}src${file.separator}main${file.separator}javascript")
    private File jsSrcDir;
    @Parameter(property="jsTestSrcDir", defaultValue="${project.basedir}${file.separator}src${file.separator}test${file.separator}javascript")
    private File jsTestSrcDir;
    @Parameter
    protected List<String> preloadSources;
    @Parameter
    protected String customRunnerTemplate;
    @Parameter
    protected String customRunnerConfiguration;
    @Parameter
    protected List<Reporter> reporters = new ArrayList<Reporter>();
    @Parameter
    protected List<FileSystemReporter> fileSystemReporters = new ArrayList<FileSystemReporter>();
    @Parameter(defaultValue="${project.build.directory}${file.separator}jasmine")
    protected File jasmineTargetDir;
    @Parameter(property="skipTests")
    protected boolean skipTests;
    @Parameter(property="maven.test.skip")
    protected boolean mvnTestSkip;
    @Parameter(property="skipJasmineTests")
    protected boolean skipJasmineTests;
    @Parameter(property="haltOnFailure", defaultValue="true")
    protected boolean haltOnFailure;
    @Parameter(defaultValue="300")
    protected int timeout;
    @Parameter(defaultValue="false")
    protected boolean debug;
    @Parameter(defaultValue="SpecRunner.html")
    protected String specRunnerHtmlFileName;
    @Parameter(defaultValue="ManualSpecRunner.html")
    protected String manualSpecRunnerHtmlFileName;
    @Parameter(defaultValue="spec")
    protected String specDirectoryName;
    @Parameter(defaultValue="src")
    protected String srcDirectoryName;
    @Parameter(defaultValue="${project.build.sourceEncoding}")
    protected String sourceEncoding;
    @Parameter
    private final List<String> sourceIncludes = ScansDirectory.DEFAULT_INCLUDES;
    @Parameter
    private final List<String> sourceExcludes = Collections.emptyList();
    @Parameter
    private final List<String> specIncludes = ScansDirectory.DEFAULT_INCLUDES;
    @Parameter
    private final List<String> specExcludes = Collections.emptyList();
    @Parameter(property="jasmine.serverPort", defaultValue="8234")
    protected int serverPort;
    @Parameter(property="jasmine.uriScheme", defaultValue="http")
    protected String uriScheme;
    @Parameter(property="jasmine.serverHostname", defaultValue="localhost")
    protected String serverHostname;
    @Parameter(property="jasmine.specRunnerTemplate", defaultValue="DEFAULT")
    protected SpecRunnerTemplate specRunnerTemplate;
    @Parameter(property="jasmine.autoRefreshInterval", defaultValue="0")
    protected int autoRefreshInterval;
    @Parameter(property="coffeeScriptCompilationEnabled", defaultValue="true")
    protected boolean coffeeScriptCompilationEnabled;
    @Parameter(property="jasmine.connectorClass", defaultValue="org.eclipse.jetty.server.nio.SelectChannelConnector")
    protected String connectorClass;
    @Parameter
    private List<Context> additionalContexts = Collections.emptyList();
    @Parameter(defaultValue="${project}", readonly=true)
    protected MavenProject mavenProject;
    @Component
    ResourceManager resourceManager;
    protected ResourceRetriever resourceRetriever;
    protected ReporterRetriever reporterRetriever;
    protected StringifiesStackTraces stringifiesStackTraces = new StringifiesStackTraces();
    protected ScriptSearch sources;
    protected ScriptSearch specs;
    private File customRunnerTemplateFile;
    private File customRunnerConfigurationFile;

    public void execute() throws MojoExecutionException, MojoFailureException {
        this.loadResources();
        this.sources = new ScriptSearch(this.jsSrcDir, this.sourceIncludes, this.sourceExcludes);
        this.specs = new ScriptSearch(this.jsTestSrcDir, this.specIncludes, this.specExcludes);
        try {
            this.run();
        }
        catch (MojoFailureException e) {
            throw e;
        }
        catch (Exception e) {
            throw new MojoExecutionException("The jasmine-maven-plugin encountered an exception: \n" + this.stringifiesStackTraces.stringify(e), e);
        }
    }

    public abstract void run() throws Exception;

    @Override
    public String getSourceEncoding() {
        return this.sourceEncoding;
    }

    @Override
    public File getCustomRunnerTemplate() {
        return this.customRunnerTemplateFile;
    }

    @Override
    public SpecRunnerTemplate getSpecRunnerTemplate() {
        return this.specRunnerTemplate;
    }

    @Override
    public File getJasmineTargetDir() {
        return this.jasmineTargetDir;
    }

    @Override
    public String getSrcDirectoryName() {
        return this.srcDirectoryName;
    }

    @Override
    public ScriptSearch getSources() {
        return this.sources;
    }

    @Override
    public ScriptSearch getSpecs() {
        return this.specs;
    }

    @Override
    public String getSpecDirectoryName() {
        return this.specDirectoryName;
    }

    @Override
    public List<String> getPreloadSources() {
        return this.preloadSources;
    }

    @Override
    public int getAutoRefreshInterval() {
        return this.autoRefreshInterval;
    }

    @Override
    public boolean isCoffeeScriptCompilationEnabled() {
        return this.coffeeScriptCompilationEnabled;
    }

    public MavenProject getMavenProject() {
        return this.mavenProject;
    }

    @Override
    public File getCustomRunnerConfiguration() {
        return this.customRunnerConfigurationFile;
    }

    @Override
    public List<Reporter> getReporters() {
        return this.reporters;
    }

    @Override
    public List<FileSystemReporter> getFileSystemReporters() {
        return this.fileSystemReporters;
    }

    @Override
    public File getBasedir() {
        return this.mavenProject.getBasedir();
    }

    @Override
    public ClassLoader getProjectClassLoader() {
        return new ProjectClassLoaderFactory(this.mavenProject.getArtifacts()).create();
    }

    @Override
    public List<Context> getContexts() {
        ArrayList<Context> contexts = new ArrayList<Context>();
        contexts.add(new Context(this.srcDirectoryName, this.jsSrcDir));
        contexts.add(new Context(this.specDirectoryName, this.jsTestSrcDir));
        contexts.addAll(this.additionalContexts);
        return contexts;
    }

    protected Connector getConnector() throws MojoExecutionException {
        try {
            Class<?> c = Class.forName(this.connectorClass);
            return (Connector)c.newInstance();
        }
        catch (InstantiationException e) {
            throw new MojoExecutionException("Unable to instantiate.", (Exception)e);
        }
        catch (IllegalAccessException e) {
            throw new MojoExecutionException("Unable to instantiate.", (Exception)e);
        }
        catch (ClassNotFoundException e) {
            throw new MojoExecutionException("Unable to instantiate.", (Exception)e);
        }
    }

    protected boolean isSkipTests() {
        return this.skipTests || this.mvnTestSkip || this.skipJasmineTests;
    }

    private void loadResources() throws MojoExecutionException {
        this.customRunnerTemplateFile = this.getResourceRetriever().getResourceAsFile("customRunnerTemplate", this.customRunnerTemplate, this.mavenProject);
        this.customRunnerConfigurationFile = this.getResourceRetriever().getResourceAsFile("customRunnerConfiguration", this.customRunnerConfiguration, this.mavenProject);
        this.reporters = this.getReporterRetriever().retrieveReporters(this.reporters, this.mavenProject);
        this.fileSystemReporters = this.getReporterRetriever().retrieveFileSystemReporters(this.fileSystemReporters, this.getJasmineTargetDir(), this.mavenProject);
    }

    private ResourceRetriever getResourceRetriever() {
        if (this.resourceRetriever == null) {
            this.resourceRetriever = new ResourceRetriever(this.resourceManager);
        }
        return this.resourceRetriever;
    }

    private ReporterRetriever getReporterRetriever() {
        if (this.reporterRetriever == null) {
            this.reporterRetriever = new ReporterRetriever(this.getResourceRetriever());
        }
        return this.reporterRetriever;
    }
}

