/*
 * Decompiled with CFR 0.152.
 */
package com.github.rawls238.scientist4j.metrics;

import com.github.rawls238.scientist4j.metrics.MetricsProvider;
import io.dropwizard.metrics5.Counter;
import io.dropwizard.metrics5.MetricRegistry;
import io.dropwizard.metrics5.Timer;
import java.util.Arrays;

public class DropwizardMetricsProvider
implements MetricsProvider<MetricRegistry> {
    private MetricRegistry registry;

    public DropwizardMetricsProvider() {
        this(new MetricRegistry());
    }

    public DropwizardMetricsProvider(MetricRegistry metricRegistry) {
        this.registry = metricRegistry;
    }

    @Override
    public MetricsProvider.Timer timer(String ... nameComponents) {
        final Timer timer = this.registry.timer(MetricRegistry.name((String)nameComponents[0], (String[])Arrays.copyOfRange(nameComponents, 1, nameComponents.length)));
        return new MetricsProvider.Timer(){
            long duration;

            @Override
            public void record(Runnable runnable) {
                Timer.Context context = timer.time();
                try {
                    runnable.run();
                }
                finally {
                    this.duration = context.stop();
                }
            }

            @Override
            public long getDuration() {
                return this.duration;
            }
        };
    }

    @Override
    public MetricsProvider.Counter counter(String ... nameComponents) {
        final Counter counter = this.registry.counter(MetricRegistry.name((String)nameComponents[0], (String[])Arrays.copyOfRange(nameComponents, 1, nameComponents.length)));
        return new MetricsProvider.Counter(){

            @Override
            public void increment() {
                counter.inc();
            }
        };
    }

    @Override
    public MetricRegistry getRegistry() {
        return this.registry;
    }

    @Override
    public void setRegistry(MetricRegistry registry) {
        this.registry = registry;
    }
}

