/*
 * Decompiled with CFR 0.152.
 */
package com.github.rawls238.scientist4j;

import com.github.rawls238.scientist4j.Experiment;
import com.github.rawls238.scientist4j.Observation;
import com.github.rawls238.scientist4j.exceptions.MismatchException;
import java.util.Map;
import java.util.Optional;

public class Result<T> {
    private Experiment experiment;
    private Observation control;
    private Optional<Observation<T>> candidate;
    private Optional<Boolean> match;
    private Map<String, Object> context;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Result(Experiment experiment, Observation<T> control, Optional<Observation<T>> candidate, Map<String, Object> context) throws MismatchException {
        block6: {
            this.experiment = experiment;
            this.control = control;
            this.candidate = candidate;
            this.context = context;
            this.match = Optional.empty();
            if (candidate.isPresent()) {
                Optional<Object> ex = Optional.empty();
                try {
                    this.match = Optional.of(experiment.compare(control, candidate.get()));
                }
                catch (MismatchException e) {
                    ex = Optional.of(e);
                    this.match = Optional.of(false);
                    return this.match;
                }
                finally {
                    if (!experiment.getRaiseOnMismatch() || !ex.isPresent()) break block6;
                    throw (MismatchException)ex.get();
                }
            }
        }
    }

    public Optional<Boolean> getMatch() {
        return this.match;
    }

    public Observation<T> getControl() {
        return this.control;
    }

    public Optional<Observation<T>> getCandidate() {
        return this.candidate;
    }

    public Map<String, Object> getContext() {
        return this.context;
    }
}

