/*
 * Decompiled with CFR 0.152.
 */
package com.github.rawls238.scientist4j;

import com.github.rawls238.scientist4j.IncompatibleTypesExperimentResult;
import com.github.rawls238.scientist4j.Observation;
import com.github.rawls238.scientist4j.exceptions.MismatchException;
import com.github.rawls238.scientist4j.metrics.MetricsProvider;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.function.BiPredicate;

public class IncompatibleTypesExperiment<T, U> {
    private static final String CONTROL = "control";
    private static final String CANDIDATE = "candidate";
    private final ExecutorService executor;
    private static final String NAMESPACE_PREFIX = "scientist";
    private final MetricsProvider<?> metricsProvider;
    private final String name;
    private final boolean raiseOnMismatch;
    private final Map<String, Object> context;
    private final MetricsProvider.Timer controlTimer;
    private final MetricsProvider.Timer candidateTimer;
    private final MetricsProvider.Counter mismatchCount;
    private final MetricsProvider.Counter candidateExceptionCount;
    private final MetricsProvider.Counter totalCount;
    private final BiPredicate<T, U> comparator;

    public IncompatibleTypesExperiment(MetricsProvider<?> metricsProvider, BiPredicate<T, U> comparator) {
        this("Experiment", metricsProvider, comparator);
    }

    public IncompatibleTypesExperiment(String name, MetricsProvider<?> metricsProvider, BiPredicate<T, U> comparator) {
        this(name, false, metricsProvider, comparator);
    }

    public IncompatibleTypesExperiment(String name, Map<String, Object> context, MetricsProvider<?> metricsProvider, BiPredicate<T, U> comparator) {
        this(name, context, false, metricsProvider, comparator);
    }

    public IncompatibleTypesExperiment(String name, boolean raiseOnMismatch, MetricsProvider<?> metricsProvider, BiPredicate<T, U> comparator) {
        this(name, new HashMap<String, Object>(), raiseOnMismatch, metricsProvider, comparator);
    }

    public IncompatibleTypesExperiment(String name, Map<String, Object> context, boolean raiseOnMismatch, MetricsProvider<?> metricsProvider, BiPredicate<T, U> comparator) {
        this(name, context, raiseOnMismatch, metricsProvider, comparator, Executors.newFixedThreadPool(2));
    }

    public IncompatibleTypesExperiment(String name, Map<String, Object> context, boolean raiseOnMismatch, MetricsProvider<?> metricsProvider, BiPredicate<T, U> comparator, ExecutorService executorService) {
        this.name = name;
        this.context = context;
        this.raiseOnMismatch = raiseOnMismatch;
        this.comparator = comparator;
        this.metricsProvider = metricsProvider;
        this.controlTimer = this.getMetricsProvider().timer(NAMESPACE_PREFIX, this.name, CONTROL);
        this.candidateTimer = this.getMetricsProvider().timer(NAMESPACE_PREFIX, this.name, CANDIDATE);
        this.mismatchCount = this.getMetricsProvider().counter(NAMESPACE_PREFIX, this.name, "mismatch");
        this.candidateExceptionCount = this.getMetricsProvider().counter(NAMESPACE_PREFIX, this.name, "candidate.exception");
        this.totalCount = this.getMetricsProvider().counter(NAMESPACE_PREFIX, this.name, "total");
        this.executor = executorService;
    }

    public MetricsProvider<?> getMetricsProvider() {
        return this.metricsProvider;
    }

    public boolean getRaiseOnMismatch() {
        return this.raiseOnMismatch;
    }

    public String getName() {
        return this.name;
    }

    public T run(Callable<T> control, Callable<U> candidate) throws Exception {
        if (this.isAsync()) {
            return this.runAsync(control, candidate);
        }
        return this.runSync(control, candidate);
    }

    private T runSync(Callable<T> control, Callable<U> candidate) throws Exception {
        Observation<T> controlObservation;
        Optional<Observation<U>> candidateObservation = Optional.empty();
        if (Math.random() < 0.5) {
            controlObservation = this.executeResult(CONTROL, this.controlTimer, control, true);
            if (this.runIf() && this.enabled()) {
                candidateObservation = Optional.of(this.executeResult(CANDIDATE, this.candidateTimer, candidate, false));
            }
        } else {
            if (this.runIf() && this.enabled()) {
                candidateObservation = Optional.of(this.executeResult(CANDIDATE, this.candidateTimer, candidate, false));
            }
            controlObservation = this.executeResult(CONTROL, this.controlTimer, control, true);
        }
        this.countExceptions(candidateObservation, this.candidateExceptionCount);
        IncompatibleTypesExperimentResult<T, U> result = new IncompatibleTypesExperimentResult<T, U>(this, controlObservation, candidateObservation, this.context);
        this.publish(result);
        return controlObservation.getValue();
    }

    public T runAsync(Callable<T> control, Callable<U> candidate) throws Exception {
        Observation controlObservation;
        Future<Optional> observationFutureCandidate;
        Future<Observation> observationFutureControl;
        if (this.runIf() && this.enabled()) {
            if (Math.random() < 0.5) {
                observationFutureControl = this.executor.submit(() -> this.executeResult(CONTROL, this.controlTimer, control, true));
                observationFutureCandidate = this.executor.submit(() -> Optional.of(this.executeResult(CANDIDATE, this.candidateTimer, candidate, false)));
            } else {
                observationFutureCandidate = this.executor.submit(() -> Optional.of(this.executeResult(CANDIDATE, this.candidateTimer, candidate, false)));
                observationFutureControl = this.executor.submit(() -> this.executeResult(CONTROL, this.controlTimer, control, true));
            }
        } else {
            observationFutureControl = this.executor.submit(() -> this.executeResult(CONTROL, this.controlTimer, control, true));
            observationFutureCandidate = null;
        }
        try {
            controlObservation = observationFutureControl.get();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException(e);
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
        Future<Void> publishedResult = this.executor.submit(() -> this.publishAsync(controlObservation, observationFutureCandidate));
        if (this.raiseOnMismatch) {
            try {
                publishedResult.get();
            }
            catch (ExecutionException e) {
                throw (Exception)e.getCause();
            }
        }
        return controlObservation.getValue();
    }

    private Void publishAsync(Observation<T> controlObservation, Future<Optional<Observation<U>>> observationFutureCandidate) throws Exception {
        Optional<Observation<U>> candidateObservation = Optional.empty();
        if (observationFutureCandidate != null) {
            candidateObservation = observationFutureCandidate.get();
        }
        this.countExceptions(candidateObservation, this.candidateExceptionCount);
        IncompatibleTypesExperimentResult<T, U> result = new IncompatibleTypesExperimentResult<T, U>(this, controlObservation, candidateObservation, this.context);
        this.publish(result);
        return null;
    }

    private void countExceptions(Optional<Observation<U>> observation, MetricsProvider.Counter exceptions) {
        if (observation.isPresent() && observation.get().getException().isPresent()) {
            exceptions.increment();
        }
    }

    public <X> Observation<X> executeResult(String name, MetricsProvider.Timer timer, Callable<X> control, boolean shouldThrow) throws Exception {
        Observation observation = new Observation(name, timer);
        observation.time(() -> {
            try {
                observation.setValue(control.call());
            }
            catch (Exception e) {
                observation.setException(e);
            }
        });
        Optional<Exception> exception = observation.getException();
        if (shouldThrow && exception.isPresent()) {
            throw exception.get();
        }
        return observation;
    }

    protected boolean compareResults(T controlVal, U candidateVal) {
        return this.comparator.test(controlVal, candidateVal);
    }

    public boolean compare(Observation<T> controlVal, Observation<U> candidateVal) throws MismatchException {
        boolean resultsMatch = !candidateVal.getException().isPresent() && this.compareResults(controlVal.getValue(), candidateVal.getValue());
        this.totalCount.increment();
        if (!resultsMatch) {
            this.mismatchCount.increment();
            this.handleComparisonMismatch(controlVal, candidateVal);
        }
        return true;
    }

    protected void publish(IncompatibleTypesExperimentResult<T, U> result) {
    }

    protected boolean runIf() {
        return true;
    }

    protected boolean enabled() {
        return true;
    }

    protected boolean isAsync() {
        return false;
    }

    private void handleComparisonMismatch(Observation<T> controlVal, Observation<U> candidateVal) throws MismatchException {
        String msg;
        Optional<Exception> exception = candidateVal.getException();
        if (exception.isPresent()) {
            String stackTrace = Arrays.toString(exception.get().getStackTrace());
            String exceptionName = exception.get().getClass().getName();
            msg = candidateVal.getName() + " raised an exception: " + exceptionName + " " + stackTrace;
        } else {
            msg = candidateVal.getName() + " does not match control value (" + controlVal.getValue().toString() + " != " + candidateVal.getValue().toString() + ")";
        }
        throw new MismatchException(msg);
    }
}

