/*
 * Decompiled with CFR 0.152.
 */
package com.jarvis.cache.serializer.kryo;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.Serializer;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import com.jarvis.cache.to.CacheWrapper;

public class CacheWrapperSerializer
extends Serializer<CacheWrapper> {
    public void write(Kryo kryo, Output output, CacheWrapper object) {
        output.writeInt(object.getExpire(), true);
        output.writeLong(object.getLastLoadTime(), true);
        kryo.writeClassAndObject(output, object.getCacheObject());
    }

    public CacheWrapper read(Kryo kryo, Input input, Class<CacheWrapper> type) {
        int expire = input.readInt(true);
        long lastLoadTime = input.readLong(true);
        Object o = kryo.readClassAndObject(input);
        CacheWrapper<Object> cacheWrapper = new CacheWrapper<Object>();
        cacheWrapper.setCacheObject(o);
        cacheWrapper.setExpire(expire);
        cacheWrapper.setLastLoadTime(lastLoadTime);
        return cacheWrapper;
    }
}

