/*
 * Decompiled with CFR 0.152.
 */
package com.jarvis.cache.serializer;

import com.jarvis.cache.serializer.ISerializer;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;

public class StringSerializer
implements ISerializer<String> {
    private final Charset charset;

    public StringSerializer() {
        this(StandardCharsets.UTF_8);
    }

    public StringSerializer(Charset charset) {
        this.charset = charset;
    }

    @Override
    public String deserialize(byte[] bytes, Type returnType) {
        return bytes == null ? null : new String(bytes, this.charset);
    }

    @Override
    public byte[] serialize(String string) {
        return string == null ? null : string.getBytes(this.charset);
    }

    @Override
    public Object deepClone(Object obj, Type type) {
        if (null == obj) {
            return obj;
        }
        String str = (String)obj;
        return String.copyValueOf(str.toCharArray());
    }

    @Override
    public Object[] deepCloneMethodArgs(Method method, Object[] args) {
        return (Object[])this.deepClone(args, null);
    }
}

