/*
 * Decompiled with CFR 0.152.
 */
package com.jarvis.cache.serializer;

import com.esotericsoftware.kryo.Serializer;
import com.jarvis.cache.serializer.ISerializer;
import com.jarvis.cache.serializer.kryo.CacheWrapperSerializer;
import com.jarvis.cache.serializer.kryo.DefaultKryoContext;
import com.jarvis.cache.serializer.kryo.KryoClassRegistration;
import com.jarvis.cache.serializer.kryo.KryoContext;
import com.jarvis.cache.to.CacheWrapper;
import com.jarvis.lib.util.BeanUtil;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Calendar;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KryoSerializer
implements ISerializer<Object> {
    private static final Logger log = LoggerFactory.getLogger(KryoSerializer.class);
    private KryoContext kryoContext = DefaultKryoContext.newKryoContextFactory(kryo -> {
        kryo.register(CacheWrapper.class, (Serializer)new CacheWrapperSerializer());
        if (log.isDebugEnabled()) {
            log.debug("kryo register classes successfully.");
        }
    });

    public void addKryoClassRegistration(KryoClassRegistration registration) {
        this.kryoContext.addKryoClassRegistration(registration);
    }

    @Override
    public byte[] serialize(Object obj) throws Exception {
        if (obj == null) {
            return null;
        }
        return this.kryoContext.serialize(obj);
    }

    @Override
    public Object deserialize(byte[] bytes, Type returnType) throws Exception {
        if (null == bytes || bytes.length == 0) {
            return null;
        }
        return this.kryoContext.deserialize(bytes);
    }

    @Override
    public Object deepClone(Object obj, Type type) throws Exception {
        if (null == obj) {
            return null;
        }
        Class<?> clazz = obj.getClass();
        if (BeanUtil.isPrimitive(obj) || clazz.isEnum() || obj instanceof Class || clazz.isAnnotation() || clazz.isSynthetic()) {
            return obj;
        }
        if (obj instanceof Date) {
            return ((Date)obj).clone();
        }
        if (obj instanceof Calendar) {
            Calendar cal = Calendar.getInstance();
            cal.setTimeInMillis(((Calendar)obj).getTime().getTime());
            return cal;
        }
        return this.deserialize(this.serialize(obj), null);
    }

    @Override
    public Object[] deepCloneMethodArgs(Method method, Object[] args) throws Exception {
        if (null == args || args.length == 0) {
            return args;
        }
        Type[] genericParameterTypes = method.getGenericParameterTypes();
        if (args.length != genericParameterTypes.length) {
            throw new Exception("the length of " + method.getDeclaringClass().getName() + "." + method.getName() + " must " + genericParameterTypes.length);
        }
        Object[] res = new Object[args.length];
        int len = genericParameterTypes.length;
        for (int i = 0; i < len; ++i) {
            res[i] = this.deepClone(args[i], null);
        }
        return res;
    }
}

