/*
 * Decompiled with CFR 0.152.
 */
package com.jarvis.cache.serializer;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.jarvis.cache.reflect.generics.ParameterizedTypeImpl;
import com.jarvis.cache.serializer.ISerializer;
import com.jarvis.cache.to.CacheWrapper;
import com.jarvis.lib.util.BeanUtil;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import org.msgpack.jackson.dataformat.MessagePackFactory;

public class JacksonMsgpackSerializer
implements ISerializer<Object> {
    private static final ObjectMapper MAPPER = new ObjectMapper((JsonFactory)new MessagePackFactory());

    @Override
    public byte[] serialize(Object obj) throws Exception {
        if (obj == null) {
            return null;
        }
        return MAPPER.writeValueAsBytes(obj);
    }

    @Override
    public Object deserialize(byte[] bytes, Type returnType) throws Exception {
        if (null == bytes || bytes.length == 0) {
            return null;
        }
        Type[] agsType = new Type[]{returnType};
        JavaType javaType = MAPPER.getTypeFactory().constructType((Type)ParameterizedTypeImpl.make(CacheWrapper.class, agsType, null));
        return MAPPER.readValue(bytes, javaType);
    }

    @Override
    public Object deepClone(Object obj, Type type) throws Exception {
        if (null == obj) {
            return null;
        }
        Class<?> clazz = obj.getClass();
        if (BeanUtil.isPrimitive(obj) || clazz.isEnum() || obj instanceof Class || clazz.isAnnotation() || clazz.isSynthetic()) {
            return obj;
        }
        if (obj instanceof Date) {
            return ((Date)obj).clone();
        }
        if (obj instanceof Calendar) {
            Calendar cal = Calendar.getInstance();
            cal.setTimeInMillis(((Calendar)obj).getTime().getTime());
            return cal;
        }
        if (null != type) {
            byte[] tmp = MAPPER.writeValueAsBytes(obj);
            JavaType javaType = MAPPER.getTypeFactory().constructType(type);
            return MAPPER.readValue(tmp, javaType);
        }
        if (clazz.isArray()) {
            Object[] arr = (Object[])obj;
            Object[] res = clazz == Object[].class ? new Object[arr.length] : (Object[])Array.newInstance(clazz.getComponentType(), arr.length);
            for (int i = 0; i < arr.length; ++i) {
                res[i] = this.deepClone(arr[i], null);
            }
            return res;
        }
        if (obj instanceof Collection) {
            Collection tempCol = (Collection)obj;
            Collection res = (Collection)tempCol.getClass().newInstance();
            Iterator it = tempCol.iterator();
            while (it.hasNext()) {
                Object val = this.deepClone(it.next(), null);
                res.add(val);
            }
            return res;
        }
        if (obj instanceof Map) {
            Map tempMap = (Map)obj;
            Map res = (Map)tempMap.getClass().newInstance();
            for (Map.Entry entry : tempMap.entrySet()) {
                Object key = entry.getKey();
                Object val = entry.getValue();
                res.put(this.deepClone(key, null), this.deepClone(val, null));
            }
            return res;
        }
        if (obj instanceof CacheWrapper) {
            CacheWrapper wrapper = (CacheWrapper)obj;
            CacheWrapper<Object> res = new CacheWrapper<Object>();
            res.setExpire(wrapper.getExpire());
            res.setLastLoadTime(wrapper.getLastLoadTime());
            res.setCacheObject(this.deepClone(wrapper.getCacheObject(), null));
            return res;
        }
        byte[] tmp = MAPPER.writeValueAsBytes(obj);
        return MAPPER.readValue(tmp, clazz);
    }

    @Override
    public Object[] deepCloneMethodArgs(Method method, Object[] args) throws Exception {
        if (null == args || args.length == 0) {
            return args;
        }
        Type[] genericParameterTypes = method.getGenericParameterTypes();
        if (args.length != genericParameterTypes.length) {
            throw new Exception("the length of " + method.getDeclaringClass().getName() + "." + method.getName() + " must " + genericParameterTypes.length);
        }
        Class<?> clazz = args.getClass();
        Object[] res = clazz == Object[].class ? new Object[args.length] : (Object[])Array.newInstance(clazz.getComponentType(), args.length);
        int len = genericParameterTypes.length;
        for (int i = 0; i < len; ++i) {
            Type genericParameterType = genericParameterTypes[i];
            Object obj = args[i];
            if (genericParameterType instanceof ParameterizedType) {
                byte[] tmp = MAPPER.writeValueAsBytes(obj);
                JavaType javaType = MAPPER.getTypeFactory().constructType(genericParameterType);
                res[i] = MAPPER.readValue(tmp, javaType);
                continue;
            }
            res[i] = this.deepClone(obj, null);
        }
        return res;
    }
}

