/*
 * Decompiled with CFR 0.152.
 */
package com.jarvis.cache.reflect.lambda;

import com.jarvis.cache.reflect.lambda.GenerateLambdaProcessor;
import com.jarvis.cache.reflect.lambda.Lambda;
import java.lang.invoke.CallSite;
import java.lang.invoke.LambdaConversionException;
import java.lang.invoke.LambdaMetafactory;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;

public class LambdaFactory {
    private static Field lookupClassAllowedModesField;
    private static final int ALL_MODES = 15;

    public static Lambda create(Method method) throws Throwable {
        return LambdaFactory.privateCreate(method, false);
    }

    public static Lambda createSpecial(Method method) throws Throwable {
        return LambdaFactory.privateCreate(method, true);
    }

    private static Lambda privateCreate(Method method, boolean createSpecial) throws Throwable {
        Class<?> returnType = method.getReturnType();
        String signatureName = GenerateLambdaProcessor.getMethodName(returnType.getSimpleName());
        return createSpecial ? LambdaFactory.createSpecial(method, Lambda.class, signatureName) : LambdaFactory.create(method, Lambda.class, signatureName);
    }

    public static Lambda create(Method method, MethodHandles.Lookup lookup) throws Throwable {
        return LambdaFactory.create(method, lookup, false);
    }

    public static Lambda createSpecial(Method method, MethodHandles.Lookup lookup) throws Throwable {
        return LambdaFactory.create(method, lookup, true);
    }

    private static Lambda create(Method method, MethodHandles.Lookup lookup, boolean invokeSpecial) throws Throwable {
        Class<?> returnType = method.getReturnType();
        String signatureName = GenerateLambdaProcessor.getMethodName(returnType.getSimpleName());
        return LambdaFactory.createLambda(method, lookup, Lambda.class, signatureName, invokeSpecial);
    }

    public static <T> T create(Method method, Class<T> interfaceClass, String signatatureName) throws Throwable {
        return LambdaFactory.create(method, interfaceClass, signatatureName, false);
    }

    public static <T> T createSpecial(Method method, Class<T> interfaceClass, String signatatureName) throws Throwable {
        return LambdaFactory.create(method, interfaceClass, signatatureName, true);
    }

    private static <T> T create(Method method, Class<T> interfaceClass, String signatureName, boolean invokeSpecial) throws Throwable {
        MethodHandles.Lookup lookup = MethodHandles.lookup().in(method.getDeclaringClass());
        LambdaFactory.setAccessible(lookup);
        return LambdaFactory.createLambda(method, lookup, interfaceClass, signatureName, invokeSpecial);
    }

    public static <T> T create(Method method, MethodHandles.Lookup lookup, Class<T> interfaceClass, String signatatureName) throws Throwable {
        return LambdaFactory.createLambda(method, lookup, interfaceClass, signatatureName, false);
    }

    public static <T> T createSpecial(Method method, MethodHandles.Lookup lookup, Class<T> interfaceClass, String signatatureName) throws Throwable {
        return LambdaFactory.createLambda(method, lookup, interfaceClass, signatatureName, true);
    }

    public static <T> T createLambda(Method method, MethodHandles.Lookup lookup, Class<T> interfaceClass, String signatatureName, boolean createSpecial) throws Throwable {
        if (method.isAccessible()) {
            lookup = lookup.in(method.getDeclaringClass());
            LambdaFactory.setAccessible(lookup);
        }
        return LambdaFactory.privateCreateLambda(method, lookup, interfaceClass, signatatureName, createSpecial);
    }

    private static <T> T privateCreateLambda(Method method, MethodHandles.Lookup lookup, Class<T> interfaceClass, String signatureName, boolean createSpecial) throws Throwable {
        MethodHandle methodHandle = createSpecial ? lookup.unreflectSpecial(method, method.getDeclaringClass()) : lookup.unreflect(method);
        MethodType instantiatedMethodType = methodHandle.type();
        MethodType signature = LambdaFactory.createLambdaMethodType(method, instantiatedMethodType);
        CallSite site = LambdaFactory.createCallSite(signatureName, lookup, methodHandle, instantiatedMethodType, signature, interfaceClass);
        MethodHandle factory = site.getTarget();
        return (T)factory.invoke();
    }

    private static MethodType createLambdaMethodType(Method method, MethodType instantiatedMethodType) {
        boolean isStatic = Modifier.isStatic(method.getModifiers());
        MethodType signature = isStatic ? instantiatedMethodType : instantiatedMethodType.changeParameterType(0, Object.class);
        Class<?>[] params = method.getParameterTypes();
        for (int i = 0; i < params.length; ++i) {
            if (!Object.class.isAssignableFrom(params[i])) continue;
            signature = signature.changeParameterType(isStatic ? i : i + 1, Object.class);
        }
        if (Object.class.isAssignableFrom((Class<?>)signature.returnType())) {
            signature = signature.changeReturnType(Object.class);
        }
        return signature;
    }

    private static CallSite createCallSite(String signatureName, MethodHandles.Lookup lookup, MethodHandle methodHandle, MethodType instantiatedMethodType, MethodType signature, Class<?> interfaceClass) throws LambdaConversionException {
        return LambdaMetafactory.metafactory(lookup, signatureName, MethodType.methodType(interfaceClass), signature, methodHandle, instantiatedMethodType);
    }

    static void setAccessible(MethodHandles.Lookup lookup) throws NoSuchFieldException, IllegalAccessException {
        LambdaFactory.getLookupsModifiersField().set(lookup, 15);
    }

    static Field getLookupsModifiersField() throws NoSuchFieldException, IllegalAccessException {
        if (lookupClassAllowedModesField == null || !lookupClassAllowedModesField.isAccessible()) {
            Field modifiersField = Field.class.getDeclaredField("modifiers");
            modifiersField.setAccessible(true);
            Field allowedModes = MethodHandles.Lookup.class.getDeclaredField("allowedModes");
            allowedModes.setAccessible(true);
            int modifiers = allowedModes.getModifiers();
            modifiersField.setInt(allowedModes, modifiers & 0xFFFFFFEF);
            lookupClassAllowedModesField = allowedModes;
        }
        return lookupClassAllowedModesField;
    }
}

