/*
 * Decompiled with CFR 0.152.
 */
package com.jarvis.cache.redis;

import com.jarvis.cache.MSetParam;
import com.jarvis.cache.redis.AbstractRedisCacheManager;
import com.jarvis.cache.redis.IRedis;
import com.jarvis.cache.redis.LettuceRedisUtil;
import com.jarvis.cache.serializer.ISerializer;
import com.jarvis.cache.to.CacheKeyTO;
import com.jarvis.cache.to.CacheWrapper;
import io.lettuce.core.AbstractRedisAsyncCommands;
import io.lettuce.core.RedisClient;
import io.lettuce.core.api.StatefulRedisConnection;
import io.lettuce.core.api.async.RedisAsyncCommands;
import io.lettuce.core.codec.ByteArrayCodec;
import io.lettuce.core.codec.RedisCodec;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LettuceRedisCacheManager
extends AbstractRedisCacheManager {
    private static final Logger log = LoggerFactory.getLogger(LettuceRedisCacheManager.class);
    private final RedisClient redisClient;

    public LettuceRedisCacheManager(RedisClient redisClient, ISerializer<Object> serializer) {
        super(serializer);
        this.redisClient = redisClient;
    }

    @Override
    protected IRedis getRedis() {
        StatefulRedisConnection connection = this.redisClient.connect((RedisCodec)ByteArrayCodec.INSTANCE);
        return new LettuceRedisClient((StatefulRedisConnection<byte[], byte[]>)connection, this);
    }

    public static class LettuceRedisClient
    implements IRedis {
        private final StatefulRedisConnection<byte[], byte[]> connection;
        private final AbstractRedisCacheManager cacheManager;

        public LettuceRedisClient(StatefulRedisConnection<byte[], byte[]> connection, AbstractRedisCacheManager cacheManager) {
            this.connection = connection;
            this.cacheManager = cacheManager;
        }

        @Override
        public void close() throws IOException {
            this.connection.close();
        }

        @Override
        public void set(byte[] key, byte[] value) {
            this.connection.async().set((Object)key, (Object)value);
        }

        @Override
        public void setex(byte[] key, int seconds, byte[] value) {
            this.connection.async().setex((Object)key, (long)seconds, (Object)value);
        }

        @Override
        public void hset(byte[] key, byte[] field, byte[] value) {
            this.connection.async().hset((Object)key, (Object)field, (Object)value);
        }

        @Override
        public void hset(byte[] key, byte[] field, byte[] value, int seconds) {
            this.connection.setAutoFlushCommands(false);
            RedisAsyncCommands asyncCommands = this.connection.async();
            asyncCommands.hset((Object)key, (Object)field, (Object)value);
            asyncCommands.expire((Object)key, (long)seconds);
            this.connection.flushCommands();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void mset(Collection<MSetParam> params) {
            this.connection.setAutoFlushCommands(false);
            RedisAsyncCommands asyncCommands = this.connection.async();
            try {
                LettuceRedisUtil.executeMSet((AbstractRedisAsyncCommands<byte[], byte[]>)((AbstractRedisAsyncCommands)asyncCommands), this.cacheManager, params);
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
            }
            finally {
                this.connection.flushCommands();
            }
        }

        @Override
        public byte[] get(byte[] key) {
            try {
                return (byte[])this.connection.async().get((Object)key).get();
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
                return null;
            }
        }

        @Override
        public byte[] hget(byte[] key, byte[] field) {
            try {
                return (byte[])this.connection.async().hget((Object)key, (Object)field).get();
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
                return null;
            }
        }

        @Override
        public Map<CacheKeyTO, CacheWrapper<Object>> mget(Type returnType, Set<CacheKeyTO> keys) {
            RedisAsyncCommands asyncCommands = this.connection.async();
            return LettuceRedisUtil.executeMGet(this.connection, (AbstractRedisAsyncCommands<byte[], byte[]>)((AbstractRedisAsyncCommands)asyncCommands), this.cacheManager, returnType, keys);
        }

        @Override
        public void delete(Set<CacheKeyTO> keys) {
            this.connection.setAutoFlushCommands(false);
            RedisAsyncCommands asyncCommands = this.connection.async();
            try {
                for (CacheKeyTO cacheKeyTO : keys) {
                    String hfield;
                    String cacheKey = cacheKeyTO.getCacheKey();
                    if (null == cacheKey || cacheKey.isEmpty()) continue;
                    if (log.isDebugEnabled()) {
                        log.debug("delete cache {}", (Object)cacheKey);
                    }
                    if (null == (hfield = cacheKeyTO.getHfield()) || hfield.isEmpty()) {
                        asyncCommands.del((Object[])new byte[][]{AbstractRedisCacheManager.KEY_SERIALIZER.serialize(cacheKey)});
                        continue;
                    }
                    asyncCommands.hdel((Object)AbstractRedisCacheManager.KEY_SERIALIZER.serialize(cacheKey), (Object[])new byte[][]{AbstractRedisCacheManager.KEY_SERIALIZER.serialize(hfield)});
                }
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
            finally {
                this.connection.flushCommands();
            }
        }
    }
}

