/*
 * Decompiled with CFR 0.152.
 */
package com.jarvis.cache.redis;

import java.io.Closeable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import redis.clients.jedis.Client;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisClusterInfoCache;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.PipelineBase;
import redis.clients.jedis.Response;
import redis.clients.jedis.exceptions.JedisRedirectionException;
import redis.clients.util.JedisClusterCRC16;
import redis.clients.util.SafeEncoder;

public class JedisClusterPipeline
extends PipelineBase
implements Closeable {
    private static final Logger log = LoggerFactory.getLogger(JedisClusterPipeline.class);
    private final JedisClusterInfoCache clusterInfoCache;
    private final Queue<Client> clients;
    private final Map<JedisPool, Jedis> jedisMap;

    public JedisClusterPipeline(JedisClusterInfoCache clusterInfoCache) {
        this.clusterInfoCache = clusterInfoCache;
        this.clients = new LinkedList<Client>();
        this.jedisMap = new HashMap<JedisPool, Jedis>(3);
    }

    protected void sync() {
        this.innerSync(null);
    }

    protected List<Object> syncAndReturnAll() {
        ArrayList<Object> responseList = new ArrayList<Object>(this.clients.size());
        this.innerSync(responseList);
        return responseList;
    }

    private void innerSync(List<Object> formatted) {
        try {
            for (Client client : this.clients) {
                Response response = this.generateResponse(client.getOne());
                if (null == formatted) continue;
                Object data = response.get();
                formatted.add(data);
            }
        }
        catch (JedisRedirectionException jre) {
            throw jre;
        }
        finally {
            this.close();
        }
    }

    @Override
    public void close() {
        this.clean();
        this.clients.clear();
        for (Jedis jedis : this.jedisMap.values()) {
            this.flushCachedData(jedis);
            jedis.close();
        }
        this.jedisMap.clear();
    }

    private void flushCachedData(Jedis jedis) {
        try {
            jedis.getClient().getAll();
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    protected Client getClient(String key) {
        byte[] bKey = SafeEncoder.encode((String)key);
        return this.getClient(bKey);
    }

    protected Client getClient(byte[] key) {
        Client client = this.getClient(JedisClusterCRC16.getSlot((byte[])key));
        this.clients.add(client);
        return client;
    }

    private Client getClient(int slot) {
        JedisPool pool = this.clusterInfoCache.getSlotPool(slot);
        Jedis jedis = this.jedisMap.get(pool);
        if (null == jedis) {
            jedis = pool.getResource();
            this.jedisMap.put(pool, jedis);
        }
        return jedis.getClient();
    }

    public JedisClusterInfoCache getClusterInfoCache() {
        return this.clusterInfoCache;
    }

    public Queue<Client> getClients() {
        return this.clients;
    }

    public Map<JedisPool, Jedis> getJedisMap() {
        return this.jedisMap;
    }
}

