/*
 * Decompiled with CFR 0.152.
 */
package com.jarvis.cache.memcache;

import com.jarvis.cache.ICacheManager;
import com.jarvis.cache.MSetParam;
import com.jarvis.cache.exception.CacheCenterConnectionException;
import com.jarvis.cache.to.CacheKeyTO;
import com.jarvis.cache.to.CacheWrapper;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import net.spy.memcached.MemcachedClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MemcachedCacheManager
implements ICacheManager {
    private static final Logger log = LoggerFactory.getLogger(MemcachedCacheManager.class);
    private MemcachedClient memcachedClient;

    @Override
    public void setCache(CacheKeyTO cacheKeyTO, CacheWrapper<Object> result, Method method) throws CacheCenterConnectionException {
        if (null == cacheKeyTO) {
            return;
        }
        String cacheKey = cacheKeyTO.getCacheKey();
        if (null == cacheKey || cacheKey.isEmpty()) {
            return;
        }
        String hfield = cacheKeyTO.getHfield();
        if (null != hfield && hfield.length() > 0) {
            throw new RuntimeException("memcached does not support hash cache.");
        }
        if (result.getExpire() >= 0) {
            this.memcachedClient.set(cacheKey, result.getExpire(), result);
        }
    }

    @Override
    public void mset(Method method, Collection<MSetParam> params) throws CacheCenterConnectionException {
        if (null == params || params.isEmpty()) {
            return;
        }
        for (MSetParam param : params) {
            if (null == param) continue;
            this.setCache(param.getCacheKey(), param.getResult(), method);
        }
    }

    @Override
    public CacheWrapper<Object> get(CacheKeyTO cacheKeyTO, Method method) throws CacheCenterConnectionException {
        if (null == cacheKeyTO) {
            return null;
        }
        String cacheKey = cacheKeyTO.getCacheKey();
        if (null == cacheKey || cacheKey.isEmpty()) {
            return null;
        }
        String hfield = cacheKeyTO.getHfield();
        if (null != hfield && hfield.length() > 0) {
            throw new RuntimeException("memcached does not support hash cache.");
        }
        return (CacheWrapper)this.memcachedClient.get(cacheKey);
    }

    @Override
    public Map<CacheKeyTO, CacheWrapper<Object>> mget(Method method, Type returnType, Set<CacheKeyTO> keys) throws CacheCenterConnectionException {
        if (null == keys || keys.isEmpty()) {
            return null;
        }
        HashMap<String, CacheKeyTO> keyMap = new HashMap<String, CacheKeyTO>(keys.size());
        for (CacheKeyTO key : keys) {
            keyMap.put(key.getCacheKey(), key);
        }
        Map values = this.memcachedClient.getBulk(keyMap.keySet());
        if (null == values || values.isEmpty()) {
            return null;
        }
        HashMap<CacheKeyTO, CacheWrapper<Object>> res = new HashMap<CacheKeyTO, CacheWrapper<Object>>(values.size());
        for (Map.Entry item : keyMap.entrySet()) {
            CacheWrapper value = (CacheWrapper)values.get(item.getKey());
            if (null == value) continue;
            res.put((CacheKeyTO)item.getValue(), value);
        }
        return res;
    }

    @Override
    public void delete(Set<CacheKeyTO> keys) throws CacheCenterConnectionException {
        if (null == this.memcachedClient || null == keys || keys.isEmpty()) {
            return;
        }
        for (CacheKeyTO cacheKeyTO : keys) {
            String cacheKey;
            if (null == cacheKeyTO || null == (cacheKey = cacheKeyTO.getCacheKey()) || cacheKey.isEmpty()) continue;
            String hfield = cacheKeyTO.getHfield();
            if (null != hfield && hfield.length() > 0) {
                throw new RuntimeException("memcached does not support hash cache.");
            }
            try {
                String allKeysPattern = "*";
                if (allKeysPattern.equals(cacheKey)) {
                    this.memcachedClient.flush();
                    continue;
                }
                this.memcachedClient.delete(cacheKey);
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    public MemcachedClient getMemcachedClient() {
        return this.memcachedClient;
    }

    public void setMemcachedClient(MemcachedClient memcachedClient) {
        this.memcachedClient = memcachedClient;
    }
}

