/*
 * Decompiled with CFR 0.152.
 */
package com.jarvis.cache.lock;

import com.jarvis.cache.lock.ILock;
import com.jarvis.cache.to.RedisLockInfo;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractRedisLock
implements ILock {
    private static final Logger log = LoggerFactory.getLogger(AbstractRedisLock.class);
    private static final ThreadLocal<Map<String, RedisLockInfo>> LOCK_START_TIME = new ThreadLocal<Map<String, RedisLockInfo>>(){

        @Override
        protected Map<String, RedisLockInfo> initialValue() {
            return new HashMap<String, RedisLockInfo>(4);
        }
    };
    protected static final String OK = "OK";
    protected static final String NX = "NX";
    protected static final String EX = "EX";

    protected abstract boolean setnx(String var1, String var2, int var3);

    protected abstract void del(String var1);

    @Override
    public boolean tryLock(String key, int lockExpire) {
        boolean locked = this.setnx(key, OK, lockExpire);
        if (locked) {
            Map<String, RedisLockInfo> startTimeMap = LOCK_START_TIME.get();
            RedisLockInfo info = new RedisLockInfo();
            info.setLeaseTime(lockExpire * 1000);
            info.setStartTime(System.currentTimeMillis());
            startTimeMap.put(key, info);
        }
        return locked;
    }

    @Override
    public void unlock(String key) {
        Map<String, RedisLockInfo> startTimeMap = LOCK_START_TIME.get();
        RedisLockInfo info = null;
        if (null != startTimeMap) {
            info = startTimeMap.remove(key);
        }
        long useTime = System.currentTimeMillis() - info.getStartTime();
        if (null != info && useTime >= (long)info.getLeaseTime().intValue()) {
            log.warn("lock(" + key + ") run timeout, use time:" + useTime);
            return;
        }
        try {
            this.del(key);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

