/*
 * Decompiled with CFR 0.152.
 */
package com.jarvis.cache;

import com.jarvis.cache.ICacheManager;
import com.jarvis.cache.MSetParam;
import com.jarvis.cache.annotation.LocalCache;
import com.jarvis.cache.exception.CacheCenterConnectionException;
import com.jarvis.cache.script.AbstractScriptParser;
import com.jarvis.cache.to.CacheKeyTO;
import com.jarvis.cache.to.CacheWrapper;
import com.jarvis.cache.to.LocalCacheWrapper;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ComboCacheManager
implements ICacheManager {
    private static final Logger log = LoggerFactory.getLogger(ComboCacheManager.class);
    private final AbstractScriptParser scriptParser;
    private ICacheManager localCache;
    private ICacheManager remoteCache;

    public ComboCacheManager(ICacheManager localCache, ICacheManager remoteCache, AbstractScriptParser scriptParser) {
        this.localCache = localCache;
        this.remoteCache = remoteCache;
        this.scriptParser = scriptParser;
    }

    @Override
    public void setCache(CacheKeyTO cacheKey, CacheWrapper<Object> result, Method method) throws CacheCenterConnectionException {
        if (method.isAnnotationPresent(LocalCache.class)) {
            LocalCache lCache = method.getAnnotation(LocalCache.class);
            this.setLocalCache(lCache, cacheKey, result, method);
            if (lCache.localOnly()) {
                return;
            }
        }
        this.remoteCache.setCache(cacheKey, result, method);
    }

    @Override
    public void mset(Method method, Collection<MSetParam> params) throws CacheCenterConnectionException {
        if (method.isAnnotationPresent(LocalCache.class)) {
            LocalCache lCache = method.getAnnotation(LocalCache.class);
            for (MSetParam param : params) {
                if (param == null) continue;
                this.setLocalCache(lCache, param.getCacheKey(), param.getResult(), method);
            }
            if (lCache.localOnly()) {
                return;
            }
        }
        this.remoteCache.mset(method, params);
    }

    private void setLocalCache(LocalCache lCache, CacheKeyTO cacheKey, CacheWrapper<Object> result, Method method) {
        try {
            LocalCacheWrapper<Object> localResult = new LocalCacheWrapper<Object>();
            localResult.setLastLoadTime(System.currentTimeMillis());
            int expire = this.scriptParser.getRealExpire(lCache.expire(), lCache.expireExpression(), null, result.getCacheObject());
            localResult.setExpire(expire);
            localResult.setCacheObject(result.getCacheObject());
            localResult.setRemoteExpire(result.getExpire());
            localResult.setRemoteLastLoadTime(result.getLastLoadTime());
            this.localCache.setCache(cacheKey, result, method);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public CacheWrapper<Object> get(CacheKeyTO key, Method method) throws CacheCenterConnectionException {
        CacheWrapper<Object> result;
        String threadName = Thread.currentThread().getName();
        if (threadName.startsWith("autoLoadThread-")) {
            return this.remoteCache.get(key, method);
        }
        LocalCache lCache = null;
        if (method.isAnnotationPresent(LocalCache.class)) {
            result = this.localCache.get(key, method);
            lCache = method.getAnnotation(LocalCache.class);
            if (null != result) {
                if (result instanceof LocalCacheWrapper) {
                    LocalCacheWrapper localResult = (LocalCacheWrapper)result;
                    CacheWrapper<Object> result2 = new CacheWrapper<Object>();
                    result2.setCacheObject(localResult.getCacheObject());
                    result2.setExpire(localResult.getRemoteExpire());
                    result2.setLastLoadTime(localResult.getRemoteLastLoadTime());
                    return result2;
                }
                return result;
            }
        }
        result = this.remoteCache.get(key, method);
        if (null != lCache && result != null) {
            this.setLocalCache(lCache, key, result, method);
        }
        return result;
    }

    @Override
    public Map<CacheKeyTO, CacheWrapper<Object>> mget(Method method, Type returnType, Set<CacheKeyTO> keys) throws CacheCenterConnectionException {
        return this.remoteCache.mget(method, returnType, keys);
    }

    @Override
    public void delete(Set<CacheKeyTO> keys) throws CacheCenterConnectionException {
        this.localCache.delete(keys);
        this.remoteCache.delete(keys);
    }
}

