/*
 * Decompiled with CFR 0.152.
 */
package com.jarvis.cache.redis;

import com.jarvis.cache.MSetParam;
import com.jarvis.cache.redis.AbstractRedisCacheManager;
import com.jarvis.cache.redis.IRedis;
import com.jarvis.cache.serializer.ISerializer;
import com.jarvis.cache.to.CacheKeyTO;
import com.jarvis.cache.to.CacheWrapper;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.redis.connection.RedisConnection;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.core.RedisConnectionUtils;

public class SpringRedisCacheManager
extends AbstractRedisCacheManager {
    private static final Logger log = LoggerFactory.getLogger(SpringRedisCacheManager.class);
    private final RedisConnectionFactory redisConnectionFactory;

    public SpringRedisCacheManager(RedisConnectionFactory redisConnectionFactory, ISerializer<Object> serializer) {
        super(serializer);
        this.redisConnectionFactory = redisConnectionFactory;
    }

    protected IRedis getRedis() {
        return new RedisConnectionClient(this.redisConnectionFactory, this);
    }

    public static class RedisConnectionClient
    implements IRedis {
        private final RedisConnectionFactory redisConnectionFactory;
        private final RedisConnection redisConnection;
        private final AbstractRedisCacheManager cacheManager;

        public RedisConnectionClient(RedisConnectionFactory redisConnectionFactory, AbstractRedisCacheManager cacheManager) {
            this.redisConnectionFactory = redisConnectionFactory;
            this.redisConnection = RedisConnectionUtils.getConnection((RedisConnectionFactory)redisConnectionFactory);
            this.cacheManager = cacheManager;
        }

        public void close() {
            RedisConnectionUtils.releaseConnection((RedisConnection)this.redisConnection, (RedisConnectionFactory)this.redisConnectionFactory);
        }

        public void set(byte[] key, byte[] value) {
            this.redisConnection.stringCommands().set(key, value);
        }

        public void setex(byte[] key, int seconds, byte[] value) {
            this.redisConnection.stringCommands().setEx(key, (long)seconds, value);
        }

        public void hset(byte[] key, byte[] field, byte[] value) {
            this.redisConnection.hashCommands().hSet(key, field, value);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void hset(byte[] key, byte[] field, byte[] value, int seconds) {
            try {
                this.redisConnection.openPipeline();
                this.redisConnection.hashCommands().hSet(key, field, value);
                this.redisConnection.keyCommands().expire(key, (long)seconds);
            }
            finally {
                this.redisConnection.closePipeline();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void mset(Collection<MSetParam> params) throws Exception {
            try {
                this.redisConnection.openPipeline();
                for (MSetParam param : params) {
                    CacheKeyTO cacheKeyTO;
                    String cacheKey;
                    if (null == param || null == (cacheKey = (cacheKeyTO = param.getCacheKey()).getCacheKey()) || cacheKey.isEmpty()) continue;
                    CacheWrapper result = param.getResult();
                    String hfield = cacheKeyTO.getHfield();
                    byte[] key = AbstractRedisCacheManager.KEY_SERIALIZER.serialize(cacheKey);
                    byte[] val = this.cacheManager.getSerializer().serialize((Object)result);
                    if (null == hfield || hfield.isEmpty()) {
                        int expire = result.getExpire();
                        if (expire == 0) {
                            this.redisConnection.stringCommands().set(key, val);
                            continue;
                        }
                        if (expire <= 0) continue;
                        this.redisConnection.stringCommands().setEx(key, (long)expire, val);
                        continue;
                    }
                    int hExpire = this.cacheManager.getHashExpire() < 0 ? result.getExpire() : this.cacheManager.getHashExpire();
                    this.redisConnection.hashCommands().hSet(key, AbstractRedisCacheManager.KEY_SERIALIZER.serialize(hfield), val);
                    if (hExpire <= 0) continue;
                    this.redisConnection.keyCommands().expire(key, (long)hExpire);
                }
            }
            finally {
                this.redisConnection.closePipeline();
            }
        }

        public byte[] get(byte[] key) {
            return this.redisConnection.stringCommands().get(key);
        }

        public byte[] hget(byte[] key, byte[] field) {
            return this.redisConnection.hashCommands().hGet(key, field);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Map<CacheKeyTO, CacheWrapper<Object>> mget(Type returnType, Set<CacheKeyTO> keys) throws Exception {
            try {
                this.redisConnection.openPipeline();
                for (CacheKeyTO cacheKeyTO : keys) {
                    String cacheKey = cacheKeyTO.getCacheKey();
                    if (null == cacheKey || cacheKey.isEmpty()) continue;
                    String hfield = cacheKeyTO.getHfield();
                    byte[] key = AbstractRedisCacheManager.KEY_SERIALIZER.serialize(cacheKey);
                    if (null == hfield || hfield.isEmpty()) {
                        this.redisConnection.stringCommands().get(key);
                        continue;
                    }
                    this.redisConnection.hashCommands().hGet(key, AbstractRedisCacheManager.KEY_SERIALIZER.serialize(hfield));
                }
            }
            finally {
                return this.cacheManager.deserialize(keys, (Collection)this.redisConnection.closePipeline(), returnType);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void delete(Set<CacheKeyTO> keys) {
            try {
                this.redisConnection.openPipeline();
                for (CacheKeyTO cacheKeyTO : keys) {
                    String hfield;
                    String cacheKey = cacheKeyTO.getCacheKey();
                    if (null == cacheKey || cacheKey.length() == 0) continue;
                    if (log.isDebugEnabled()) {
                        log.debug("delete cache {}", (Object)cacheKey);
                    }
                    if (null == (hfield = cacheKeyTO.getHfield()) || hfield.length() == 0) {
                        this.redisConnection.keyCommands().del((byte[][])new byte[][]{AbstractRedisCacheManager.KEY_SERIALIZER.serialize(cacheKey)});
                        continue;
                    }
                    this.redisConnection.hashCommands().hDel(AbstractRedisCacheManager.KEY_SERIALIZER.serialize(cacheKey), (byte[][])new byte[][]{AbstractRedisCacheManager.KEY_SERIALIZER.serialize(hfield)});
                }
            }
            finally {
                this.redisConnection.closePipeline();
            }
        }
    }
}

