/*
 * Decompiled with CFR 0.152.
 */
package com.jarvis.cache.autoconfigure;

import com.jarvis.cache.autoconfigure.AutoloadCacheManageConfiguration;
import com.jarvis.cache.lock.ILock;
import com.jarvis.cache.redis.SpringRedisLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.redis.connection.RedisConnectionFactory;

@Configuration
@AutoConfigureAfter(value={AutoloadCacheManageConfiguration.class})
public class DistributedLockConfiguration {
    private static final Logger logger = LoggerFactory.getLogger(DistributedLockConfiguration.class);

    @Bean
    @ConditionalOnMissingBean(value={ILock.class})
    @ConditionalOnClass(value={RedisConnectionFactory.class})
    @ConditionalOnBean(value={RedisConnectionFactory.class})
    public ILock autoLoadCacheDistributedLock(RedisConnectionFactory connectionFactory) {
        if (null == connectionFactory) {
            return null;
        }
        SpringRedisLock lock = new SpringRedisLock(connectionFactory);
        if (logger.isDebugEnabled()) {
            logger.debug("ILock with SpringJedisLock auto-configured");
        }
        return lock;
    }
}

