/*
 * Decompiled with CFR 0.152.
 */
package com.plexpt.chatgpt.entity.chat;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.plexpt.chatgpt.entity.chat.FunctionCallResult;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class Message {
    private String role;
    private String content;
    private String name;
    @JsonProperty(value="function_call")
    private FunctionCallResult functionCall;

    public Message(String role, String content) {
        this.role = role;
        this.content = content;
    }

    public static Message of(String content) {
        return new Message(Role.USER.getValue(), content);
    }

    public static Message ofSystem(String content) {
        return new Message(Role.SYSTEM.getValue(), content);
    }

    public static Message ofAssistant(String content) {
        return new Message(Role.ASSISTANT.getValue(), content);
    }

    public static Message ofFunction(String function) {
        return new Message(Role.FUNCTION.getValue(), function);
    }

    public static MessageBuilder builder() {
        return new MessageBuilder();
    }

    public String getRole() {
        return this.role;
    }

    public String getContent() {
        return this.content;
    }

    public String getName() {
        return this.name;
    }

    public FunctionCallResult getFunctionCall() {
        return this.functionCall;
    }

    public void setRole(String role) {
        this.role = role;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public void setName(String name) {
        this.name = name;
    }

    @JsonProperty(value="function_call")
    public void setFunctionCall(FunctionCallResult functionCall) {
        this.functionCall = functionCall;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Message)) {
            return false;
        }
        Message other = (Message)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$role = this.getRole();
        String other$role = other.getRole();
        if (this$role == null ? other$role != null : !this$role.equals(other$role)) {
            return false;
        }
        String this$content = this.getContent();
        String other$content = other.getContent();
        if (this$content == null ? other$content != null : !this$content.equals(other$content)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        FunctionCallResult this$functionCall = this.getFunctionCall();
        FunctionCallResult other$functionCall = other.getFunctionCall();
        return !(this$functionCall == null ? other$functionCall != null : !((Object)this$functionCall).equals(other$functionCall));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Message;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $role = this.getRole();
        result = result * 59 + ($role == null ? 43 : $role.hashCode());
        String $content = this.getContent();
        result = result * 59 + ($content == null ? 43 : $content.hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        FunctionCallResult $functionCall = this.getFunctionCall();
        result = result * 59 + ($functionCall == null ? 43 : ((Object)$functionCall).hashCode());
        return result;
    }

    public String toString() {
        return "Message(role=" + this.getRole() + ", content=" + this.getContent() + ", name=" + this.getName() + ", functionCall=" + this.getFunctionCall() + ")";
    }

    public Message(String role, String content, String name, FunctionCallResult functionCall) {
        this.role = role;
        this.content = content;
        this.name = name;
        this.functionCall = functionCall;
    }

    public Message() {
    }

    public static class MessageBuilder {
        private String role;
        private String content;
        private String name;
        private FunctionCallResult functionCall;

        MessageBuilder() {
        }

        public MessageBuilder role(String role) {
            this.role = role;
            return this;
        }

        public MessageBuilder content(String content) {
            this.content = content;
            return this;
        }

        public MessageBuilder name(String name) {
            this.name = name;
            return this;
        }

        @JsonProperty(value="function_call")
        public MessageBuilder functionCall(FunctionCallResult functionCall) {
            this.functionCall = functionCall;
            return this;
        }

        public Message build() {
            return new Message(this.role, this.content, this.name, this.functionCall);
        }

        public String toString() {
            return "Message.MessageBuilder(role=" + this.role + ", content=" + this.content + ", name=" + this.name + ", functionCall=" + this.functionCall + ")";
        }
    }

    public static enum Role {
        SYSTEM("system"),
        USER("user"),
        ASSISTANT("assistant"),
        FUNCTION("function");

        private String value;

        public String getValue() {
            return this.value;
        }

        private Role(String value) {
            this.value = value;
        }
    }
}

